/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.Server;
import com.paypal.sdk.controllers.BaseController;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.exceptions.ErrorException;
import com.paypal.sdk.http.request.HttpMethod;
import com.paypal.sdk.http.response.ApiResponse;
import com.paypal.sdk.models.Order;
import com.paypal.sdk.models.OrderAuthorizeResponse;
import com.paypal.sdk.models.OrdersAuthorizeInput;
import com.paypal.sdk.models.OrdersCaptureInput;
import com.paypal.sdk.models.OrdersConfirmInput;
import com.paypal.sdk.models.OrdersCreateInput;
import com.paypal.sdk.models.OrdersGetInput;
import com.paypal.sdk.models.OrdersPatchInput;
import com.paypal.sdk.models.OrdersTrackCreateInput;
import com.paypal.sdk.models.OrdersTrackersPatchInput;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.Method;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public final class OrdersController
extends BaseController {
    public OrdersController(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    public ApiResponse<OrderAuthorizeResponse> ordersAuthorize(OrdersAuthorizeInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersAuthorizeRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<OrderAuthorizeResponse>> ordersAuthorizeAsync(OrdersAuthorizeInput input) {
        try {
            return this.prepareOrdersAuthorizeRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<OrderAuthorizeResponse>, ApiException> prepareOrdersAuthorizeRequest(OrdersAuthorizeInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/authorize").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (OrderAuthorizeResponse)ApiHelper.deserialize((String)response, OrderAuthorizeResponse.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The authorized payment failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> ordersTrackCreate(OrdersTrackCreateInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersTrackCreateRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> ordersTrackCreateAsync(OrdersTrackCreateInput input) {
        try {
            return this.prepareOrdersTrackCreateRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareOrdersTrackCreateRequest(OrdersTrackCreateInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/track").bodyParam(param -> param.value((Object)input.getBody())).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> ordersCreate(OrdersCreateInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersCreateRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> ordersCreateAsync(OrdersCreateInput input) {
        try {
            return this.prepareOrdersCreateRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareOrdersCreateRequest(OrdersCreateInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders").bodyParam(param -> param.value((Object)input.getBody())).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("PayPal-Partner-Attribution-Id").value((Object)input.getPaypalPartnerAttributionId()).isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Void> ordersPatch(OrdersPatchInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersPatchRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Void>> ordersPatchAsync(OrdersPatchInput input) {
        try {
            return this.prepareOrdersPatchRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Void>, ApiException> prepareOrdersPatchRequest(OrdersPatchInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}").bodyParam(param -> param.value(input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize(input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.PATCH)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> ordersCapture(OrdersCaptureInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersCaptureRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> ordersCaptureAsync(OrdersCaptureInput input) {
        try {
            return this.prepareOrdersCaptureRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareOrdersCaptureRequest(OrdersCaptureInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/capture").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Request-Id").value((Object)input.getPaypalRequestId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("PayPal-Auth-Assertion").value((Object)input.getPaypalAuthAssertion()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"The authorized payment failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> ordersGet(OrdersGetInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersGetRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> ordersGetAsync(OrdersGetInput input) {
        try {
            return this.prepareOrdersGetRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareOrdersGetRequest(OrdersGetInput input) throws IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}").queryParam(param -> param.key("fields").value((Object)input.getFields()).isRequired(false)).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.GET)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("401", ErrorCase.setReason((String)"Authentication failed due to missing authorization header, or invalid authentication credentials.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Order> ordersConfirm(OrdersConfirmInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersConfirmRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Order>> ordersConfirmAsync(OrdersConfirmInput input) {
        try {
            return this.prepareOrdersConfirmRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Order>, ApiException> prepareOrdersConfirmRequest(OrdersConfirmInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/confirm-payment-source").bodyParam(param -> param.value((Object)input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize((Object)input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).headerParam(param -> param.key("PayPal-Client-Metadata-Id").value((Object)input.getPaypalClientMetadataId()).isRequired(false)).headerParam(param -> param.key("Prefer").value((Object)input.getPrefer()).isRequired(false)).headerParam(param -> param.key("accept").value((Object)"application/json")).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.POST)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).apiResponseDeserializer(response -> (Order)ApiHelper.deserialize((String)response, Order.class)).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }

    public ApiResponse<Void> ordersTrackersPatch(OrdersTrackersPatchInput input) throws ApiException, IOException {
        return (ApiResponse)this.prepareOrdersTrackersPatchRequest(input).execute();
    }

    public CompletableFuture<ApiResponse<Void>> ordersTrackersPatchAsync(OrdersTrackersPatchInput input) {
        try {
            return this.prepareOrdersTrackersPatchRequest(input).executeAsync();
        }
        catch (Exception e) {
            throw new CompletionException(e);
        }
    }

    private ApiCall<ApiResponse<Void>, ApiException> prepareOrdersTrackersPatchRequest(OrdersTrackersPatchInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder().globalConfig(this.getGlobalConfiguration()).requestBuilder(requestBuilder -> requestBuilder.server(Server.ENUM_DEFAULT.value()).path("/v2/checkout/orders/{id}/trackers/{tracker_id}").bodyParam(param -> param.value(input.getBody()).isRequired(false)).bodySerializer(() -> ApiHelper.serialize(input.getBody())).templateParam(param -> param.key("id").value((Object)input.getId()).shouldEncode(true)).templateParam(param -> param.key("tracker_id").value((Object)input.getTrackerId()).shouldEncode(true)).headerParam(param -> param.key("Content-Type").value((Object)"application/json").isRequired(false)).withAuth(auth -> auth.add("Oauth2")).httpMethod((Method)HttpMethod.PATCH)).responseHandler(responseHandler -> responseHandler.responseClassType(ResponseClassType.API_RESPONSE).nullify404(false).localErrorCase("400", ErrorCase.setReason((String)"Request is not well-formed, syntactically incorrect, or violates schema.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("403", ErrorCase.setReason((String)"Authorization failed due to insufficient permissions.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("404", ErrorCase.setReason((String)"The specified resource does not exist.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("422", ErrorCase.setReason((String)"The requested action could not be performed, semantically incorrect, or failed business validation.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("500", ErrorCase.setReason((String)"An internal server error has occurred.", (reason, context) -> new ErrorException(reason, context))).localErrorCase("DEFAULT", ErrorCase.setReason((String)"The error response.", (reason, context) -> new ErrorException(reason, context))).globalErrorCase(GLOBAL_ERROR_CASES)).build();
    }
}

