/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.ApplePayPaymentData;
import com.paypal.sdk.models.ApplePayPaymentDataType;
import com.paypal.sdk.models.ApplePayTokenizedCard;
import com.paypal.sdk.models.Money;

public class ApplePayDecryptedTokenData {
    private Money transactionAmount;
    private ApplePayTokenizedCard tokenizedCard;
    private String deviceManufacturerId;
    private ApplePayPaymentDataType paymentDataType;
    private ApplePayPaymentData paymentData;

    public ApplePayDecryptedTokenData() {
    }

    public ApplePayDecryptedTokenData(ApplePayTokenizedCard tokenizedCard, Money transactionAmount, String deviceManufacturerId, ApplePayPaymentDataType paymentDataType, ApplePayPaymentData paymentData) {
        this.transactionAmount = transactionAmount;
        this.tokenizedCard = tokenizedCard;
        this.deviceManufacturerId = deviceManufacturerId;
        this.paymentDataType = paymentDataType;
        this.paymentData = paymentData;
    }

    @JsonGetter(value="transaction_amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getTransactionAmount() {
        return this.transactionAmount;
    }

    @JsonSetter(value="transaction_amount")
    public void setTransactionAmount(Money transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    @JsonGetter(value="tokenized_card")
    public ApplePayTokenizedCard getTokenizedCard() {
        return this.tokenizedCard;
    }

    @JsonSetter(value="tokenized_card")
    public void setTokenizedCard(ApplePayTokenizedCard tokenizedCard) {
        this.tokenizedCard = tokenizedCard;
    }

    @JsonGetter(value="device_manufacturer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDeviceManufacturerId() {
        return this.deviceManufacturerId;
    }

    @JsonSetter(value="device_manufacturer_id")
    public void setDeviceManufacturerId(String deviceManufacturerId) {
        this.deviceManufacturerId = deviceManufacturerId;
    }

    @JsonGetter(value="payment_data_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ApplePayPaymentDataType getPaymentDataType() {
        return this.paymentDataType;
    }

    @JsonSetter(value="payment_data_type")
    public void setPaymentDataType(ApplePayPaymentDataType paymentDataType) {
        this.paymentDataType = paymentDataType;
    }

    @JsonGetter(value="payment_data")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ApplePayPaymentData getPaymentData() {
        return this.paymentData;
    }

    @JsonSetter(value="payment_data")
    public void setPaymentData(ApplePayPaymentData paymentData) {
        this.paymentData = paymentData;
    }

    public String toString() {
        return "ApplePayDecryptedTokenData [tokenizedCard=" + this.tokenizedCard + ", transactionAmount=" + this.transactionAmount + ", deviceManufacturerId=" + this.deviceManufacturerId + ", paymentDataType=" + (Object)((Object)this.paymentDataType) + ", paymentData=" + this.paymentData + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.tokenizedCard).transactionAmount(this.getTransactionAmount()).deviceManufacturerId(this.getDeviceManufacturerId()).paymentDataType(this.getPaymentDataType()).paymentData(this.getPaymentData());
        return builder;
    }

    public static class Builder {
        private ApplePayTokenizedCard tokenizedCard;
        private Money transactionAmount;
        private String deviceManufacturerId;
        private ApplePayPaymentDataType paymentDataType;
        private ApplePayPaymentData paymentData;

        public Builder() {
        }

        public Builder(ApplePayTokenizedCard tokenizedCard) {
            this.tokenizedCard = tokenizedCard;
        }

        public Builder tokenizedCard(ApplePayTokenizedCard tokenizedCard) {
            this.tokenizedCard = tokenizedCard;
            return this;
        }

        public Builder transactionAmount(Money transactionAmount) {
            this.transactionAmount = transactionAmount;
            return this;
        }

        public Builder deviceManufacturerId(String deviceManufacturerId) {
            this.deviceManufacturerId = deviceManufacturerId;
            return this;
        }

        public Builder paymentDataType(ApplePayPaymentDataType paymentDataType) {
            this.paymentDataType = paymentDataType;
            return this;
        }

        public Builder paymentData(ApplePayPaymentData paymentData) {
            this.paymentData = paymentData;
            return this;
        }

        public ApplePayDecryptedTokenData build() {
            return new ApplePayDecryptedTokenData(this.tokenizedCard, this.transactionAmount, this.deviceManufacturerId, this.paymentDataType, this.paymentData);
        }
    }
}

