/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class AuthorizationsVoidInput {
    private String authorizationId;
    private String paypalAuthAssertion;
    private String prefer;

    public AuthorizationsVoidInput() {
        this.prefer = "return=minimal";
    }

    public AuthorizationsVoidInput(String authorizationId, String paypalAuthAssertion, String prefer) {
        this.authorizationId = authorizationId;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.prefer = prefer;
    }

    @JsonGetter(value="authorization_id")
    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @JsonSetter(value="authorization_id")
    public void setAuthorizationId(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    public String toString() {
        return "AuthorizationsVoidInput [authorizationId=" + this.authorizationId + ", paypalAuthAssertion=" + this.paypalAuthAssertion + ", prefer=" + this.prefer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.authorizationId).paypalAuthAssertion(this.getPaypalAuthAssertion()).prefer(this.getPrefer());
        return builder;
    }

    public static class Builder {
        private String authorizationId;
        private String paypalAuthAssertion;
        private String prefer = "return=minimal";

        public Builder() {
        }

        public Builder(String authorizationId) {
            this.authorizationId = authorizationId;
        }

        public Builder authorizationId(String authorizationId) {
            this.authorizationId = authorizationId;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public AuthorizationsVoidInput build() {
            return new AuthorizationsVoidInput(this.authorizationId, this.paypalAuthAssertion, this.prefer);
        }
    }
}

