/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.GooglePayAuthenticationMethod;
import com.paypal.sdk.models.GooglePayPaymentMethod;

public class GooglePayDecryptedTokenData {
    private String messageId;
    private String messageExpiration;
    private GooglePayPaymentMethod paymentMethod;
    private GooglePayAuthenticationMethod authenticationMethod;
    private String cryptogram;
    private String eciIndicator;

    public GooglePayDecryptedTokenData() {
    }

    public GooglePayDecryptedTokenData(GooglePayPaymentMethod paymentMethod, GooglePayAuthenticationMethod authenticationMethod, String messageId, String messageExpiration, String cryptogram, String eciIndicator) {
        this.messageId = messageId;
        this.messageExpiration = messageExpiration;
        this.paymentMethod = paymentMethod;
        this.authenticationMethod = authenticationMethod;
        this.cryptogram = cryptogram;
        this.eciIndicator = eciIndicator;
    }

    @JsonGetter(value="message_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMessageId() {
        return this.messageId;
    }

    @JsonSetter(value="message_id")
    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @JsonGetter(value="message_expiration")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getMessageExpiration() {
        return this.messageExpiration;
    }

    @JsonSetter(value="message_expiration")
    public void setMessageExpiration(String messageExpiration) {
        this.messageExpiration = messageExpiration;
    }

    @JsonGetter(value="payment_method")
    public GooglePayPaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @JsonSetter(value="payment_method")
    public void setPaymentMethod(GooglePayPaymentMethod paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @JsonGetter(value="authentication_method")
    public GooglePayAuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    @JsonSetter(value="authentication_method")
    public void setAuthenticationMethod(GooglePayAuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    @JsonGetter(value="cryptogram")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCryptogram() {
        return this.cryptogram;
    }

    @JsonSetter(value="cryptogram")
    public void setCryptogram(String cryptogram) {
        this.cryptogram = cryptogram;
    }

    @JsonGetter(value="eci_indicator")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEciIndicator() {
        return this.eciIndicator;
    }

    @JsonSetter(value="eci_indicator")
    public void setEciIndicator(String eciIndicator) {
        this.eciIndicator = eciIndicator;
    }

    public String toString() {
        return "GooglePayDecryptedTokenData [paymentMethod=" + (Object)((Object)this.paymentMethod) + ", authenticationMethod=" + (Object)((Object)this.authenticationMethod) + ", messageId=" + this.messageId + ", messageExpiration=" + this.messageExpiration + ", cryptogram=" + this.cryptogram + ", eciIndicator=" + this.eciIndicator + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentMethod, this.authenticationMethod).messageId(this.getMessageId()).messageExpiration(this.getMessageExpiration()).cryptogram(this.getCryptogram()).eciIndicator(this.getEciIndicator());
        return builder;
    }

    public static class Builder {
        private GooglePayPaymentMethod paymentMethod;
        private GooglePayAuthenticationMethod authenticationMethod;
        private String messageId;
        private String messageExpiration;
        private String cryptogram;
        private String eciIndicator;

        public Builder() {
        }

        public Builder(GooglePayPaymentMethod paymentMethod, GooglePayAuthenticationMethod authenticationMethod) {
            this.paymentMethod = paymentMethod;
            this.authenticationMethod = authenticationMethod;
        }

        public Builder paymentMethod(GooglePayPaymentMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        public Builder authenticationMethod(GooglePayAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder messageExpiration(String messageExpiration) {
            this.messageExpiration = messageExpiration;
            return this;
        }

        public Builder cryptogram(String cryptogram) {
            this.cryptogram = cryptogram;
            return this;
        }

        public Builder eciIndicator(String eciIndicator) {
            this.eciIndicator = eciIndicator;
            return this;
        }

        public GooglePayDecryptedTokenData build() {
            return new GooglePayDecryptedTokenData(this.paymentMethod, this.authenticationMethod, this.messageId, this.messageExpiration, this.cryptogram, this.eciIndicator);
        }
    }
}

