/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.EciFlag;

public class NetworkToken {
    private String number;
    private String expiry;
    private String cryptogram;
    private EciFlag eciFlag;
    private String tokenRequestorId;

    public NetworkToken() {
    }

    public NetworkToken(String number, String expiry, String cryptogram, EciFlag eciFlag, String tokenRequestorId) {
        this.number = number;
        this.expiry = expiry;
        this.cryptogram = cryptogram;
        this.eciFlag = eciFlag;
        this.tokenRequestorId = tokenRequestorId;
    }

    @JsonGetter(value="number")
    public String getNumber() {
        return this.number;
    }

    @JsonSetter(value="number")
    public void setNumber(String number) {
        this.number = number;
    }

    @JsonGetter(value="expiry")
    public String getExpiry() {
        return this.expiry;
    }

    @JsonSetter(value="expiry")
    public void setExpiry(String expiry) {
        this.expiry = expiry;
    }

    @JsonGetter(value="cryptogram")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCryptogram() {
        return this.cryptogram;
    }

    @JsonSetter(value="cryptogram")
    public void setCryptogram(String cryptogram) {
        this.cryptogram = cryptogram;
    }

    @JsonGetter(value="eci_flag")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public EciFlag getEciFlag() {
        return this.eciFlag;
    }

    @JsonSetter(value="eci_flag")
    public void setEciFlag(EciFlag eciFlag) {
        this.eciFlag = eciFlag;
    }

    @JsonGetter(value="token_requestor_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTokenRequestorId() {
        return this.tokenRequestorId;
    }

    @JsonSetter(value="token_requestor_id")
    public void setTokenRequestorId(String tokenRequestorId) {
        this.tokenRequestorId = tokenRequestorId;
    }

    public String toString() {
        return "NetworkToken [number=" + this.number + ", expiry=" + this.expiry + ", cryptogram=" + this.cryptogram + ", eciFlag=" + (Object)((Object)this.eciFlag) + ", tokenRequestorId=" + this.tokenRequestorId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.number, this.expiry).cryptogram(this.getCryptogram()).eciFlag(this.getEciFlag()).tokenRequestorId(this.getTokenRequestorId());
        return builder;
    }

    public static class Builder {
        private String number;
        private String expiry;
        private String cryptogram;
        private EciFlag eciFlag;
        private String tokenRequestorId;

        public Builder() {
        }

        public Builder(String number, String expiry) {
            this.number = number;
            this.expiry = expiry;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public Builder expiry(String expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder cryptogram(String cryptogram) {
            this.cryptogram = cryptogram;
            return this;
        }

        public Builder eciFlag(EciFlag eciFlag) {
            this.eciFlag = eciFlag;
            return this;
        }

        public Builder tokenRequestorId(String tokenRequestorId) {
            this.tokenRequestorId = tokenRequestorId;
            return this;
        }

        public NetworkToken build() {
            return new NetworkToken(this.number, this.expiry, this.cryptogram, this.eciFlag, this.tokenRequestorId);
        }
    }
}

