/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderTrackerItem;
import com.paypal.sdk.models.ShipmentCarrier;
import java.util.List;

public class OrderTrackerRequest {
    private String trackingNumber;
    private ShipmentCarrier carrier;
    private String carrierNameOther;
    private String captureId;
    private Boolean notifyPayer;
    private List<OrderTrackerItem> items;

    public OrderTrackerRequest() {
        this.notifyPayer = false;
    }

    public OrderTrackerRequest(String captureId, String trackingNumber, ShipmentCarrier carrier, String carrierNameOther, Boolean notifyPayer, List<OrderTrackerItem> items) {
        this.trackingNumber = trackingNumber;
        this.carrier = carrier;
        this.carrierNameOther = carrierNameOther;
        this.captureId = captureId;
        this.notifyPayer = notifyPayer;
        this.items = items;
    }

    @JsonGetter(value="tracking_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    @JsonSetter(value="tracking_number")
    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @JsonGetter(value="carrier")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ShipmentCarrier getCarrier() {
        return this.carrier;
    }

    @JsonSetter(value="carrier")
    public void setCarrier(ShipmentCarrier carrier) {
        this.carrier = carrier;
    }

    @JsonGetter(value="carrier_name_other")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCarrierNameOther() {
        return this.carrierNameOther;
    }

    @JsonSetter(value="carrier_name_other")
    public void setCarrierNameOther(String carrierNameOther) {
        this.carrierNameOther = carrierNameOther;
    }

    @JsonGetter(value="capture_id")
    public String getCaptureId() {
        return this.captureId;
    }

    @JsonSetter(value="capture_id")
    public void setCaptureId(String captureId) {
        this.captureId = captureId;
    }

    @JsonGetter(value="notify_payer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getNotifyPayer() {
        return this.notifyPayer;
    }

    @JsonSetter(value="notify_payer")
    public void setNotifyPayer(Boolean notifyPayer) {
        this.notifyPayer = notifyPayer;
    }

    @JsonGetter(value="items")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderTrackerItem> getItems() {
        return this.items;
    }

    @JsonSetter(value="items")
    public void setItems(List<OrderTrackerItem> items) {
        this.items = items;
    }

    public String toString() {
        return "OrderTrackerRequest [captureId=" + this.captureId + ", trackingNumber=" + this.trackingNumber + ", carrier=" + (Object)((Object)this.carrier) + ", carrierNameOther=" + this.carrierNameOther + ", notifyPayer=" + this.notifyPayer + ", items=" + this.items + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.captureId).trackingNumber(this.getTrackingNumber()).carrier(this.getCarrier()).carrierNameOther(this.getCarrierNameOther()).notifyPayer(this.getNotifyPayer()).items(this.getItems());
        return builder;
    }

    public static class Builder {
        private String captureId;
        private String trackingNumber;
        private ShipmentCarrier carrier;
        private String carrierNameOther;
        private Boolean notifyPayer = false;
        private List<OrderTrackerItem> items;

        public Builder() {
        }

        public Builder(String captureId) {
            this.captureId = captureId;
        }

        public Builder captureId(String captureId) {
            this.captureId = captureId;
            return this;
        }

        public Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        public Builder carrier(ShipmentCarrier carrier) {
            this.carrier = carrier;
            return this;
        }

        public Builder carrierNameOther(String carrierNameOther) {
            this.carrierNameOther = carrierNameOther;
            return this;
        }

        public Builder notifyPayer(Boolean notifyPayer) {
            this.notifyPayer = notifyPayer;
            return this;
        }

        public Builder items(List<OrderTrackerItem> items) {
            this.items = items;
            return this;
        }

        public OrderTrackerRequest build() {
            return new OrderTrackerRequest(this.captureId, this.trackingNumber, this.carrier, this.carrierNameOther, this.notifyPayer, this.items);
        }
    }
}

