/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderCaptureRequest;

public class OrdersCaptureInput {
    private String id;
    private String contentType;
    private String paypalRequestId;
    private String prefer;
    private String paypalClientMetadataId;
    private String paypalAuthAssertion;
    private OrderCaptureRequest body;

    public OrdersCaptureInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public OrdersCaptureInput(String id, String contentType, String paypalRequestId, String prefer, String paypalClientMetadataId, String paypalAuthAssertion, OrderCaptureRequest body) {
        this.id = id;
        this.contentType = contentType;
        this.paypalRequestId = paypalRequestId;
        this.prefer = prefer;
        this.paypalClientMetadataId = paypalClientMetadataId;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    @JsonGetter(value="PayPal-Client-Metadata-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalClientMetadataId() {
        return this.paypalClientMetadataId;
    }

    @JsonSetter(value="PayPal-Client-Metadata-Id")
    public void setPaypalClientMetadataId(String paypalClientMetadataId) {
        this.paypalClientMetadataId = paypalClientMetadataId;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="body")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public OrderCaptureRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(OrderCaptureRequest body) {
        this.body = body;
    }

    public String toString() {
        return "OrdersCaptureInput [id=" + this.id + ", contentType=" + this.contentType + ", paypalRequestId=" + this.paypalRequestId + ", prefer=" + this.prefer + ", paypalClientMetadataId=" + this.paypalClientMetadataId + ", paypalAuthAssertion=" + this.paypalAuthAssertion + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.contentType).paypalRequestId(this.getPaypalRequestId()).prefer(this.getPrefer()).paypalClientMetadataId(this.getPaypalClientMetadataId()).paypalAuthAssertion(this.getPaypalAuthAssertion()).body(this.getBody());
        return builder;
    }

    public static class Builder {
        private String id;
        private String contentType = "application/json";
        private String paypalRequestId;
        private String prefer = "return=minimal";
        private String paypalClientMetadataId;
        private String paypalAuthAssertion;
        private OrderCaptureRequest body;

        public Builder() {
        }

        public Builder(String id, String contentType) {
            this.id = id;
            this.contentType = contentType;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public Builder paypalClientMetadataId(String paypalClientMetadataId) {
            this.paypalClientMetadataId = paypalClientMetadataId;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public Builder body(OrderCaptureRequest body) {
            this.body = body;
            return this;
        }

        public OrdersCaptureInput build() {
            return new OrdersCaptureInput(this.id, this.contentType, this.paypalRequestId, this.prefer, this.paypalClientMetadataId, this.paypalAuthAssertion, this.body);
        }
    }
}

