/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderRequest;

public class OrdersCreateInput {
    private String contentType;
    private OrderRequest body;
    private String paypalRequestId;
    private String paypalPartnerAttributionId;
    private String paypalClientMetadataId;
    private String prefer;

    public OrdersCreateInput() {
        this.contentType = "application/json";
        this.prefer = "return=minimal";
    }

    public OrdersCreateInput(String contentType, OrderRequest body, String paypalRequestId, String paypalPartnerAttributionId, String paypalClientMetadataId, String prefer) {
        this.contentType = contentType;
        this.body = body;
        this.paypalRequestId = paypalRequestId;
        this.paypalPartnerAttributionId = paypalPartnerAttributionId;
        this.paypalClientMetadataId = paypalClientMetadataId;
        this.prefer = prefer;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public OrderRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(OrderRequest body) {
        this.body = body;
    }

    @JsonGetter(value="PayPal-Request-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="PayPal-Partner-Attribution-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalPartnerAttributionId() {
        return this.paypalPartnerAttributionId;
    }

    @JsonSetter(value="PayPal-Partner-Attribution-Id")
    public void setPaypalPartnerAttributionId(String paypalPartnerAttributionId) {
        this.paypalPartnerAttributionId = paypalPartnerAttributionId;
    }

    @JsonGetter(value="PayPal-Client-Metadata-Id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalClientMetadataId() {
        return this.paypalClientMetadataId;
    }

    @JsonSetter(value="PayPal-Client-Metadata-Id")
    public void setPaypalClientMetadataId(String paypalClientMetadataId) {
        this.paypalClientMetadataId = paypalClientMetadataId;
    }

    @JsonGetter(value="Prefer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPrefer() {
        return this.prefer;
    }

    @JsonSetter(value="Prefer")
    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    public String toString() {
        return "OrdersCreateInput [contentType=" + this.contentType + ", body=" + this.body + ", paypalRequestId=" + this.paypalRequestId + ", paypalPartnerAttributionId=" + this.paypalPartnerAttributionId + ", paypalClientMetadataId=" + this.paypalClientMetadataId + ", prefer=" + this.prefer + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.contentType, this.body).paypalRequestId(this.getPaypalRequestId()).paypalPartnerAttributionId(this.getPaypalPartnerAttributionId()).paypalClientMetadataId(this.getPaypalClientMetadataId()).prefer(this.getPrefer());
        return builder;
    }

    public static class Builder {
        private String contentType = "application/json";
        private OrderRequest body;
        private String paypalRequestId;
        private String paypalPartnerAttributionId;
        private String paypalClientMetadataId;
        private String prefer = "return=minimal";

        public Builder() {
        }

        public Builder(String contentType, OrderRequest body) {
            this.contentType = contentType;
            this.body = body;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(OrderRequest body) {
            this.body = body;
            return this;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder paypalPartnerAttributionId(String paypalPartnerAttributionId) {
            this.paypalPartnerAttributionId = paypalPartnerAttributionId;
            return this;
        }

        public Builder paypalClientMetadataId(String paypalClientMetadataId) {
            this.paypalClientMetadataId = paypalClientMetadataId;
            return this;
        }

        public Builder prefer(String prefer) {
            this.prefer = prefer;
            return this;
        }

        public OrdersCreateInput build() {
            return new OrdersCreateInput(this.contentType, this.body, this.paypalRequestId, this.paypalPartnerAttributionId, this.paypalClientMetadataId, this.prefer);
        }
    }
}

