/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Address;
import com.paypal.sdk.models.Name;
import com.paypal.sdk.models.PhoneWithType;
import com.paypal.sdk.models.TaxInfo;

public class Payer {
    private String emailAddress;
    private String payerId;
    private Name name;
    private PhoneWithType phone;
    private String birthDate;
    private TaxInfo taxInfo;
    private Address address;

    public Payer() {
    }

    public Payer(String emailAddress, String payerId, Name name, PhoneWithType phone, String birthDate, TaxInfo taxInfo, Address address) {
        this.emailAddress = emailAddress;
        this.payerId = payerId;
        this.name = name;
        this.phone = phone;
        this.birthDate = birthDate;
        this.taxInfo = taxInfo;
        this.address = address;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonSetter(value="email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @JsonGetter(value="payer_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayerId() {
        return this.payerId;
    }

    @JsonSetter(value="payer_id")
    public void setPayerId(String payerId) {
        this.payerId = payerId;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Name getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(Name name) {
        this.name = name;
    }

    @JsonGetter(value="phone")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PhoneWithType getPhone() {
        return this.phone;
    }

    @JsonSetter(value="phone")
    public void setPhone(PhoneWithType phone) {
        this.phone = phone;
    }

    @JsonGetter(value="birth_date")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getBirthDate() {
        return this.birthDate;
    }

    @JsonSetter(value="birth_date")
    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    @JsonGetter(value="tax_info")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public TaxInfo getTaxInfo() {
        return this.taxInfo;
    }

    @JsonSetter(value="tax_info")
    public void setTaxInfo(TaxInfo taxInfo) {
        this.taxInfo = taxInfo;
    }

    @JsonGetter(value="address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Address getAddress() {
        return this.address;
    }

    @JsonSetter(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    public String toString() {
        return "Payer [emailAddress=" + this.emailAddress + ", payerId=" + this.payerId + ", name=" + this.name + ", phone=" + this.phone + ", birthDate=" + this.birthDate + ", taxInfo=" + this.taxInfo + ", address=" + this.address + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().emailAddress(this.getEmailAddress()).payerId(this.getPayerId()).name(this.getName()).phone(this.getPhone()).birthDate(this.getBirthDate()).taxInfo(this.getTaxInfo()).address(this.getAddress());
        return builder;
    }

    public static class Builder {
        private String emailAddress;
        private String payerId;
        private Name name;
        private PhoneWithType phone;
        private String birthDate;
        private TaxInfo taxInfo;
        private Address address;

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder payerId(String payerId) {
            this.payerId = payerId;
            return this;
        }

        public Builder name(Name name) {
            this.name = name;
            return this;
        }

        public Builder phone(PhoneWithType phone) {
            this.phone = phone;
            return this;
        }

        public Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public Builder taxInfo(TaxInfo taxInfo) {
            this.taxInfo = taxInfo;
            return this;
        }

        public Builder address(Address address) {
            this.address = address;
            return this;
        }

        public Payer build() {
            return new Payer(this.emailAddress, this.payerId, this.name, this.phone, this.birthDate, this.taxInfo, this.address);
        }
    }
}

