/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.DisbursementMode;
import com.paypal.sdk.models.PlatformFee;
import java.util.List;

public class PaymentInstruction {
    private List<PlatformFee> platformFees;
    private DisbursementMode disbursementMode;
    private String payeePricingTierId;
    private String payeeReceivableFxRateId;

    public PaymentInstruction() {
        this.disbursementMode = DisbursementMode.INSTANT;
    }

    public PaymentInstruction(List<PlatformFee> platformFees, DisbursementMode disbursementMode, String payeePricingTierId, String payeeReceivableFxRateId) {
        this.platformFees = platformFees;
        this.disbursementMode = disbursementMode;
        this.payeePricingTierId = payeePricingTierId;
        this.payeeReceivableFxRateId = payeeReceivableFxRateId;
    }

    @JsonGetter(value="platform_fees")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<PlatformFee> getPlatformFees() {
        return this.platformFees;
    }

    @JsonSetter(value="platform_fees")
    public void setPlatformFees(List<PlatformFee> platformFees) {
        this.platformFees = platformFees;
    }

    @JsonGetter(value="disbursement_mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DisbursementMode getDisbursementMode() {
        return this.disbursementMode;
    }

    @JsonSetter(value="disbursement_mode")
    public void setDisbursementMode(DisbursementMode disbursementMode) {
        this.disbursementMode = disbursementMode;
    }

    @JsonGetter(value="payee_pricing_tier_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayeePricingTierId() {
        return this.payeePricingTierId;
    }

    @JsonSetter(value="payee_pricing_tier_id")
    public void setPayeePricingTierId(String payeePricingTierId) {
        this.payeePricingTierId = payeePricingTierId;
    }

    @JsonGetter(value="payee_receivable_fx_rate_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPayeeReceivableFxRateId() {
        return this.payeeReceivableFxRateId;
    }

    @JsonSetter(value="payee_receivable_fx_rate_id")
    public void setPayeeReceivableFxRateId(String payeeReceivableFxRateId) {
        this.payeeReceivableFxRateId = payeeReceivableFxRateId;
    }

    public String toString() {
        return "PaymentInstruction [platformFees=" + this.platformFees + ", disbursementMode=" + (Object)((Object)this.disbursementMode) + ", payeePricingTierId=" + this.payeePricingTierId + ", payeeReceivableFxRateId=" + this.payeeReceivableFxRateId + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().platformFees(this.getPlatformFees()).disbursementMode(this.getDisbursementMode()).payeePricingTierId(this.getPayeePricingTierId()).payeeReceivableFxRateId(this.getPayeeReceivableFxRateId());
        return builder;
    }

    public static class Builder {
        private List<PlatformFee> platformFees;
        private DisbursementMode disbursementMode = DisbursementMode.INSTANT;
        private String payeePricingTierId;
        private String payeeReceivableFxRateId;

        public Builder platformFees(List<PlatformFee> platformFees) {
            this.platformFees = platformFees;
            return this;
        }

        public Builder disbursementMode(DisbursementMode disbursementMode) {
            this.disbursementMode = disbursementMode;
            return this;
        }

        public Builder payeePricingTierId(String payeePricingTierId) {
            this.payeePricingTierId = payeePricingTierId;
            return this;
        }

        public Builder payeeReceivableFxRateId(String payeeReceivableFxRateId) {
            this.payeeReceivableFxRateId = payeeReceivableFxRateId;
            return this;
        }

        public PaymentInstruction build() {
            return new PaymentInstruction(this.platformFees, this.disbursementMode, this.payeePricingTierId, this.payeeReceivableFxRateId);
        }
    }
}

