/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PaymentTokenRequestCard;
import com.paypal.sdk.models.VaultTokenRequest;

public class PaymentTokenRequestPaymentSource {
    private PaymentTokenRequestCard card;
    private VaultTokenRequest token;

    public PaymentTokenRequestPaymentSource() {
    }

    public PaymentTokenRequestPaymentSource(PaymentTokenRequestCard card, VaultTokenRequest token) {
        this.card = card;
        this.token = token;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaymentTokenRequestCard getCard() {
        return this.card;
    }

    @JsonSetter(value="card")
    public void setCard(PaymentTokenRequestCard card) {
        this.card = card;
    }

    @JsonGetter(value="token")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VaultTokenRequest getToken() {
        return this.token;
    }

    @JsonSetter(value="token")
    public void setToken(VaultTokenRequest token) {
        this.token = token;
    }

    public String toString() {
        return "PaymentTokenRequestPaymentSource [card=" + this.card + ", token=" + this.token + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().card(this.getCard()).token(this.getToken());
        return builder;
    }

    public static class Builder {
        private PaymentTokenRequestCard card;
        private VaultTokenRequest token;

        public Builder card(PaymentTokenRequestCard card) {
            this.card = card;
            return this;
        }

        public Builder token(VaultTokenRequest token) {
            this.token = token;
            return this;
        }

        public PaymentTokenRequestPaymentSource build() {
            return new PaymentTokenRequestPaymentSource(this.card, this.token);
        }
    }
}

