/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.PaymentTokenRequest;

public class PaymentTokensCreateInput {
    private String paypalRequestId;
    private String contentType;
    private PaymentTokenRequest body;

    public PaymentTokensCreateInput() {
        this.contentType = "application/json";
    }

    public PaymentTokensCreateInput(String paypalRequestId, String contentType, PaymentTokenRequest body) {
        this.paypalRequestId = paypalRequestId;
        this.contentType = contentType;
        this.body = body;
    }

    @JsonGetter(value="PayPal-Request-Id")
    public String getPaypalRequestId() {
        return this.paypalRequestId;
    }

    @JsonSetter(value="PayPal-Request-Id")
    public void setPaypalRequestId(String paypalRequestId) {
        this.paypalRequestId = paypalRequestId;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public PaymentTokenRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(PaymentTokenRequest body) {
        this.body = body;
    }

    public String toString() {
        return "PaymentTokensCreateInput [paypalRequestId=" + this.paypalRequestId + ", contentType=" + this.contentType + ", body=" + this.body + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paypalRequestId, this.contentType, this.body);
        return builder;
    }

    public static class Builder {
        private String paypalRequestId;
        private String contentType = "application/json";
        private PaymentTokenRequest body;

        public Builder() {
        }

        public Builder(String paypalRequestId, String contentType, PaymentTokenRequest body) {
            this.paypalRequestId = paypalRequestId;
            this.contentType = contentType;
            this.body = body;
        }

        public Builder paypalRequestId(String paypalRequestId) {
            this.paypalRequestId = paypalRequestId;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(PaymentTokenRequest body) {
            this.body = body;
            return this;
        }

        public PaymentTokensCreateInput build() {
            return new PaymentTokensCreateInput(this.paypalRequestId, this.contentType, this.body);
        }
    }
}

