/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

public class RequestTokenInput {
    private String grantType;
    private String authorization;
    private String scope;

    public RequestTokenInput() {
        this.grantType = "client_credentials";
    }

    public RequestTokenInput(String grantType, String authorization, String scope) {
        this.grantType = grantType;
        this.authorization = authorization;
        this.scope = scope;
    }

    @JsonGetter(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @JsonSetter(value="grant_type")
    private void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @JsonGetter(value="Authorization")
    public String getAuthorization() {
        return this.authorization;
    }

    @JsonSetter(value="Authorization")
    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    @JsonGetter(value="scope")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getScope() {
        return this.scope;
    }

    @JsonSetter(value="scope")
    public void setScope(String scope) {
        this.scope = scope;
    }

    public String toString() {
        return "RequestTokenInput [grantType=" + this.grantType + ", authorization=" + this.authorization + ", scope=" + this.scope + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.grantType, this.authorization).scope(this.getScope());
        return builder;
    }

    public static class Builder {
        private String grantType = "client_credentials";
        private String authorization;
        private String scope;

        public Builder() {
        }

        public Builder(String grantType, String authorization) {
            this.grantType = grantType;
            this.authorization = authorization;
        }

        public Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder authorization(String authorization) {
            this.authorization = authorization;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public RequestTokenInput build() {
            return new RequestTokenInput(this.grantType, this.authorization, this.scope);
        }
    }
}

