/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum UpcType {
    UPCA,
    UPCB,
    UPCC,
    UPCD,
    UPCE,
    UPC2,
    UPC5,
    _UNKNOWN;

    private static TreeMap<String, UpcType> valueMap;
    private String value;

    @JsonCreator
    public static UpcType constructFromString(String toConvert) throws IOException {
        UpcType enumValue = UpcType.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static UpcType fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<UpcType> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (UpcType enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        UpcType.UPCA.value = "UPC-A";
        UpcType.UPCB.value = "UPC-B";
        UpcType.UPCC.value = "UPC-C";
        UpcType.UPCD.value = "UPC-D";
        UpcType.UPCE.value = "UPC-E";
        UpcType.UPC2.value = "UPC-2";
        UpcType.UPC5.value = "UPC-5";
        UpcType._UNKNOWN.value = null;
        valueMap.put("UPC-A", UPCA);
        valueMap.put("UPC-B", UPCB);
        valueMap.put("UPC-C", UPCC);
        valueMap.put("UPC-D", UPCD);
        valueMap.put("UPC-E", UPCE);
        valueMap.put("UPC-2", UPC2);
        valueMap.put("UPC-5", UPC5);
    }
}

