/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Links;
import com.paypal.core.SDKVersion;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.OAuthTokenCredential;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import com.paypal.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Refund {
    private String id;
    private String createTime;
    private String updateTime;
    private Amount amount;
    private String state;
    private String saleId;
    private String captureId;
    private String parentPayment;
    private String description;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static OAuthTokenCredential initConfig(InputStream is) throws PayPalRESTException {
        return PayPalResource.initConfig((InputStream)is);
    }

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        return PayPalResource.initConfig((File)file);
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        return PayPalResource.initConfig((Properties)properties);
    }

    public Refund setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Refund setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Refund setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Refund setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Refund setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Refund setSaleId(String saleId) {
        this.saleId = saleId;
        return this;
    }

    public String getSaleId() {
        return this.saleId;
    }

    public Refund setCaptureId(String captureId) {
        this.captureId = captureId;
        return this;
    }

    public String getCaptureId() {
        return this.captureId;
    }

    public Refund setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public Refund setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Refund setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public static Refund get(String accessToken, String refundId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Refund.get(apiContext, refundId);
    }

    public static Refund get(APIContext apiContext, String refundId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (refundId == null) {
            throw new IllegalArgumentException("refundId cannot be null");
        }
        Object[] parameters = new Object[]{refundId};
        String pattern = "v1/payments/refund/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Refund)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Refund.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

