/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Links;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.PaymentExecution;
import com.paypal.api.payments.PaymentHistory;
import com.paypal.api.payments.RedirectUrls;
import com.paypal.api.payments.Transaction;
import com.paypal.core.SDKVersion;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.OAuthTokenCredential;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import com.paypal.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payment {
    private String id;
    private String createTime;
    private String updateTime;
    private String intent;
    private String experienceProfileId;
    private Payer payer;
    private Object cart;
    private List<Transaction> transactions;
    private String state;
    private RedirectUrls redirectUrls;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static OAuthTokenCredential initConfig(InputStream is) throws PayPalRESTException {
        return PayPalResource.initConfig((InputStream)is);
    }

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        return PayPalResource.initConfig((File)file);
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        return PayPalResource.initConfig((Properties)properties);
    }

    public Payment() {
    }

    public Payment(String intent, Payer payer) {
        this.intent = intent;
        this.payer = payer;
    }

    public Payment setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Payment setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Payment setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Payment setIntent(String intent) {
        this.intent = intent;
        return this;
    }

    public String getIntent() {
        return this.intent;
    }

    public String getExperienceProfileId() {
        return this.experienceProfileId;
    }

    public void setExperienceProfileId(String experienceProfileId) {
        this.experienceProfileId = experienceProfileId;
    }

    public Payment setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Payment setCart(Object cart) {
        this.cart = cart;
        return this;
    }

    public Object getCart() {
        return this.cart;
    }

    public Payment setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
        return this;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Payment setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Payment setRedirectUrls(RedirectUrls redirectUrls) {
        this.redirectUrls = redirectUrls;
        return this;
    }

    public RedirectUrls getRedirectUrls() {
        return this.redirectUrls;
    }

    public Payment setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Payment create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Payment create(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        String resourcePath = "v1/payments/payment";
        String payLoad = this.toJSON();
        return (Payment)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Payment.class);
    }

    public static Payment get(String accessToken, String paymentId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payment.get(apiContext, paymentId);
    }

    public static Payment get(APIContext apiContext, String paymentId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (paymentId == null) {
            throw new IllegalArgumentException("paymentId cannot be null");
        }
        Object[] parameters = new Object[]{paymentId};
        String pattern = "v1/payments/payment/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Payment)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Payment.class);
    }

    public Payment execute(String accessToken, PaymentExecution paymentExecution) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.execute(apiContext, paymentExecution);
    }

    public Payment execute(APIContext apiContext, PaymentExecution paymentExecution) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (paymentExecution == null) {
            throw new IllegalArgumentException("paymentExecution cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/payment/{0}/execute";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = paymentExecution.toJSON();
        return (Payment)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Payment.class);
    }

    public static PaymentHistory list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Payment.list(apiContext, containerMap);
    }

    public static PaymentHistory list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (containerMap == null) {
            throw new IllegalArgumentException("containerMap cannot be null");
        }
        Object[] parameters = new Object[]{containerMap};
        String pattern = "v1/payments/payment?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payee_id={5}&sort_by={6}&sort_order={7}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (PaymentHistory)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, PaymentHistory.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

