/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Payment;
import com.paypal.core.ClientCredentials;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.sdk.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.sdk.openidconnect.CreateFromRefreshTokenParameters;
import com.paypal.sdk.openidconnect.Tokeninfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class FuturePayment
extends Payment {
    private Properties getCredential() throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(new FileReader(new File(".", "src/main/resources/sdk_config.properties")));
        return properties;
    }

    public Payment create(String accessToken, String correlationId) throws PayPalRESTException, FileNotFoundException, IOException {
        if (correlationId == null || correlationId.equals("")) {
            throw new IllegalArgumentException("correlation ID cannot be null or empty");
        }
        APIContext apiContext = new APIContext(accessToken);
        apiContext.setHTTPHeaders(new HashMap());
        apiContext.getHTTPHeaders().put("PAYPAL-CLIENT-METADATA-ID", correlationId);
        return this.create(apiContext);
    }

    public Tokeninfo getTokeninfo(CreateFromAuthorizationCodeParameters params) throws PayPalRESTException {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        configurationMap.put("clientId", params.getClientID());
        configurationMap.put("clientSecret", params.getClientSecret());
        configurationMap.put("response_type", "token");
        APIContext apiContext = new APIContext();
        apiContext.setConfigurationMap(configurationMap);
        params.setRedirectURI("urn:ietf:wg:oauth:2.0:oob");
        Tokeninfo info = Tokeninfo.createFromAuthorizationCodeForFpp((APIContext)apiContext, (CreateFromAuthorizationCodeParameters)params);
        return info;
    }

    public Tokeninfo getTokeninfo(CreateFromRefreshTokenParameters params, Tokeninfo info) throws PayPalRESTException {
        HashMap configurationMap = new HashMap();
        APIContext apiContext = new APIContext();
        apiContext.setConfigurationMap(configurationMap);
        info = info.createFromRefreshToken(apiContext, params);
        return info;
    }

    public ClientCredentials getClientCredential() throws FileNotFoundException, IOException {
        ClientCredentials credentials = new ClientCredentials();
        Properties properties = this.getCredential();
        credentials.setClientID(properties.getProperty("clientID"));
        credentials.setClientSecret(properties.getProperty("clientSecret"));
        return credentials;
    }
}

