/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Authorization;
import com.paypal.api.payments.Capture;
import com.paypal.core.SDKVersion;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.OAuthTokenCredential;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import com.paypal.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

public class Order {
    private String id;
    private String purchaseUnitReferenceId;
    private String createTime;
    private String updateTime;
    private Amount amount;
    private String paymentMode;
    private String state;
    private String protectionEligibility;
    private String protectionEligibilityType;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static OAuthTokenCredential initConfig(InputStream is) throws PayPalRESTException {
        return PayPalResource.initConfig((InputStream)is);
    }

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        return PayPalResource.initConfig((File)file);
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        return PayPalResource.initConfig((Properties)properties);
    }

    public Order() {
    }

    public Order(String id, Amount amount, String state) {
        this.id = id;
        this.amount = amount;
        this.state = state;
    }

    public Order setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Order setPurchaseUnitReferenceId(String purchaseUnitReferenceId) {
        this.purchaseUnitReferenceId = purchaseUnitReferenceId;
        return this;
    }

    public String getPurchaseUnitReferenceId() {
        return this.purchaseUnitReferenceId;
    }

    public Order setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Order setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Order setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Order setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
        return this;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public Order setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Order setProtectionEligibility(String protectionEligibility) {
        this.protectionEligibility = protectionEligibility;
        return this;
    }

    public String getProtectionEligibility() {
        return this.protectionEligibility;
    }

    public Order setProtectionEligibilityType(String protectionEligibilityType) {
        this.protectionEligibilityType = protectionEligibilityType;
        return this;
    }

    public String getProtectionEligibilityType() {
        return this.protectionEligibilityType;
    }

    public static Order get(String accessToken, String orderId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Order.get(apiContext, orderId);
    }

    public static Order get(APIContext apiContext, String orderId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (orderId == null) {
            throw new IllegalArgumentException("orderId cannot be null");
        }
        Object[] parameters = new Object[]{orderId};
        String pattern = "v1/payments/orders/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Order)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Order.class);
    }

    public Capture capture(String accessToken, Capture capture) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.capture(apiContext, capture);
    }

    public Capture capture(APIContext apiContext, Capture capture) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (capture == null) {
            throw new IllegalArgumentException("capture cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/orders/{0}/capture";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = capture.toJSON();
        return (Capture)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Capture.class);
    }

    public Order doVoid(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.doVoid(apiContext);
    }

    public Order doVoid(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/orders/{0}/do-void";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Order)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Order.class);
    }

    public Authorization authorize(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.authorize(apiContext);
    }

    public Authorization authorize(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/orders/{0}/authorization";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = this.toJSON();
        return (Authorization)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Authorization.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

