/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Link;
import com.paypal.api.payments.Refund;
import com.paypal.api.payments.Resource;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sale
extends Resource {
    private String id;
    private String createTime;
    private String updateTime;
    private String state;
    private Amount amount;
    private String parentPayment;
    private List<Link> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static void initConfig(InputStream is) throws PayPalRESTException {
        PayPalResource.initConfig(is);
    }

    public static void initConfig(File file) throws PayPalRESTException {
        PayPalResource.initConfig(file);
    }

    public static void initConfig(Properties properties) {
        PayPalResource.initConfig(properties);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public void setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public static Sale get(String accessToken, String saleId) throws PayPalRESTException {
        if (saleId == null || saleId.length() <= 0) {
            throw new IllegalArgumentException("saleId cannot be null or empty");
        }
        String pattern = "v1/payments/sale/{0}";
        Object[] parameters = new Object[]{saleId};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(accessToken, HttpMethod.GET, resourcePath, payLoad, Sale.class);
    }

    public Refund refund(String accessToken, Refund refund) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.refund(apiContext, refund);
    }

    public Refund refund(APIContext apiContext, Refund refund) throws PayPalRESTException {
        if (refund == null) {
            throw new IllegalArgumentException("refund cannot be null");
        }
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        String pattern = "v1/payments/sale/{0}/refund";
        Object[] parameters = new Object[]{this.getId()};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = refund.toJSON();
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Refund.class);
    }

    @Override
    public String toJSON() {
        return JSONFormatter.toJSON(this);
    }

    @Override
    public String toString() {
        return this.toJSON();
    }
}

