/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.paypal.core.ConfigManager;
import com.paypal.core.ConnectionManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.credential.ICredential;
import com.paypal.core.rest.PayPalRESTException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

public final class OAuthTokenCredential
implements ICredential {
    private static final String OAUTH_TOKEN_PATH = "/v1/oauth2/token";
    private String clientID;
    private String clientSecret;
    private String accessToken;
    private transient String appId;

    public OAuthTokenCredential(String clientID, String clientSecret) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
    }

    public String getAccessToken() throws PayPalRESTException {
        if (this.accessToken == null) {
            this.accessToken = this.generateAccessToken();
        }
        return this.accessToken;
    }

    private String generateAccessToken() throws PayPalRESTException {
        String generatedToken = null;
        String base64ClientID = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        generatedToken = this.generateOAuthToken(base64ClientID);
        return generatedToken;
    }

    private String generateBase64String(String clientID) throws PayPalRESTException {
        String base64ClientID = null;
        byte[] encoded = null;
        try {
            encoded = Base64.encodeBase64((byte[])clientID.getBytes("UTF-8"));
            base64ClientID = new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return base64ClientID;
    }

    private String generateOAuthToken(String base64ClientID) throws PayPalRESTException {
        HttpConnection connection = null;
        HttpConfiguration httpConfiguration = null;
        String generatedToken = null;
        try {
            connection = ConnectionManager.getInstance().getConnection();
            httpConfiguration = this.getOAuthHttpConfiguration();
            connection.createAndconfigureHttpConnection(httpConfiguration);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + base64ClientID);
            headers.put("Accept", "*/*");
            String postRequest = "grant_type=client_credentials";
            String jsonResponse = connection.execute("", postRequest, headers);
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(jsonResponse);
            generatedToken = jsonElement.getAsJsonObject().get("token_type").getAsString() + " " + jsonElement.getAsJsonObject().get("access_token").getAsString();
            this.appId = jsonElement.getAsJsonObject().get("app_id").getAsString();
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return generatedToken;
    }

    private HttpConfiguration getOAuthHttpConfiguration() {
        ConfigManager config = ConfigManager.getInstance();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod("POST");
        String endPointUrl = config.getValue("service.EndPoint") + OAUTH_TOKEN_PATH;
        httpConfiguration.setEndPointUrl(endPointUrl);
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(config.getValue("http.GoogleAppEngine")));
        return httpConfiguration;
    }
}

