/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.paypal.core.ConfigManager;
import com.paypal.core.ConnectionManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.HttpConnection;
import com.paypal.core.LoggingManager;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.RESTConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PayPalResource {
    public static final String SDK_ID = "ID";
    public static final String SDK_VERSION = "0.5.2";
    private static boolean configInitialized = false;
    private static final ThreadLocal<String> LASTREQUEST = new ThreadLocal();
    private static final ThreadLocal<String> LASTRESPONSE = new ThreadLocal();

    public static void initConfig(InputStream is) throws PayPalRESTException {
        try {
            ConfigManager.getInstance().load(is);
            configInitialized = true;
        }
        catch (IOException ioe) {
            LoggingManager.severe(PayPalResource.class, (Object)ioe.getMessage(), (Throwable)ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static void initConfig(File file) throws PayPalRESTException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File doesn't exist: " + file.getAbsolutePath());
            }
            FileInputStream fis = new FileInputStream(file);
            PayPalResource.initConfig(fis);
            configInitialized = true;
        }
        catch (IOException ioe) {
            LoggingManager.severe(PayPalResource.class, (Object)ioe.getMessage(), (Throwable)ioe);
            throw new PayPalRESTException(ioe.getMessage(), ioe);
        }
    }

    public static void initConfig(Properties properties) {
        ConfigManager.getInstance().load(properties);
        configInitialized = true;
    }

    private static void initializeToDefault() throws PayPalRESTException {
        PayPalResource.initConfig(PayPalResource.class.getClassLoader().getResourceAsStream("sdk_config.properties"));
    }

    public static String getLastRequest() {
        return LASTREQUEST.get();
    }

    public static String getLastResponse() {
        return LASTRESPONSE.get();
    }

    public static <T> T configureAndExecute(String accessToken, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        if (!configInitialized) {
            PayPalResource.initializeToDefault();
        }
        RESTConfiguration restConfiguration = PayPalResource.createRESTConfiguration(httpMethod, resourcePath, accessToken, null);
        t = PayPalResource.execute(restConfiguration, payLoad, resourcePath, clazz);
        return t;
    }

    public static <T> T configureAndExecute(APIContext apiContext, HttpMethod httpMethod, String resourcePath, String payLoad, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        if (!configInitialized) {
            PayPalResource.initializeToDefault();
        }
        RESTConfiguration restConfiguration = PayPalResource.createRESTConfiguration(httpMethod, resourcePath, apiContext.getAccessToken(), apiContext.getRequestId());
        t = PayPalResource.execute(restConfiguration, payLoad, resourcePath, clazz);
        return t;
    }

    private static RESTConfiguration createRESTConfiguration(HttpMethod httpMethod, String resourcePath, String accessToken, String requestId) {
        RESTConfiguration restConfiguration = new RESTConfiguration();
        restConfiguration.setHttpMethod(httpMethod);
        restConfiguration.setResourcePath(resourcePath);
        restConfiguration.setRequestId(requestId);
        restConfiguration.setAuthorizationToken(accessToken);
        return restConfiguration;
    }

    private static <T> T execute(RESTConfiguration restConfiguration, String payLoad, String resourcePath, Class<T> clazz) throws PayPalRESTException {
        T t = null;
        try {
            Map<String, String> headers = restConfiguration.getHeaders();
            HttpConfiguration httpConfig = restConfiguration.getHttpConfigurations();
            ConnectionManager connectionManager = ConnectionManager.getInstance();
            HttpConnection httpConnection = connectionManager.getConnection(httpConfig);
            httpConnection.createAndconfigureHttpConnection(httpConfig);
            LASTREQUEST.set(payLoad);
            String responseString = httpConnection.execute(restConfiguration.getBaseURL().toURI().resolve(resourcePath).toString(), payLoad, headers);
            LASTRESPONSE.set(responseString);
            t = JSONFormatter.fromJSON(responseString, clazz);
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return t;
    }
}

