/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.rest;

import com.paypal.core.ConfigManager;
import com.paypal.core.HttpConfiguration;
import com.paypal.core.rest.HttpMethod;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RESTConfiguration {
    private static final String JAVAHEADER;
    private static final String OSHEADER;
    private URL url;
    private String authorizationToken;
    private HttpMethod httpMethod;
    private String resourcePath;
    private String requestId;

    public void setAuthorizationToken(String authorizationToken) {
        this.authorizationToken = authorizationToken;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", this.authorizationToken);
        headers.put("User-Agent", this.formUserAgentHeader());
        if (this.requestId != null && this.requestId.length() > 0) {
            headers.put("PayPal-Request-Id", this.requestId);
        }
        return headers;
    }

    public HttpConfiguration getHttpConfigurations() throws MalformedURLException, URISyntaxException {
        ConfigManager config = ConfigManager.getInstance();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod(this.httpMethod.toString());
        httpConfiguration.setEndPointUrl(this.getBaseURL().toURI().resolve(this.resourcePath).toString());
        httpConfiguration.setContentType("application/json");
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(config.getValue("http.GoogleAppEngine")));
        if (Boolean.parseBoolean(config.getValue("http.UseProxy"))) {
            httpConfiguration.setProxyPort(Integer.parseInt(config.getValue("http.ProxyPort")));
            httpConfiguration.setProxyHost(config.getValue("http.ProxyHost"));
            httpConfiguration.setProxyUserName(config.getValue("http.ProxyUserName"));
            httpConfiguration.setProxyPassword(config.getValue("http.ProxyPassword"));
        }
        httpConfiguration.setConnectionTimeout(Integer.parseInt(config.getValue("http.ConnectionTimeOut")));
        httpConfiguration.setMaxRetry(Integer.parseInt(config.getValue("http.Retry")));
        httpConfiguration.setReadTimeout(Integer.parseInt(config.getValue("http.ReadTimeOut")));
        httpConfiguration.setMaxHttpConnection(Integer.parseInt(config.getValue("http.MaxConnection")));
        httpConfiguration.setIpAddress(config.getValue("http.IPAddress"));
        return httpConfiguration;
    }

    public URL getBaseURL() throws MalformedURLException {
        if (this.url == null) {
            String urlString = ConfigManager.getInstance().getValue("service.EndPoint");
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            this.url = new URL(urlString);
        }
        return this.url;
    }

    public void setUrl(String urlString) throws MalformedURLException {
        if (urlString != null && urlString.length() > 0) {
            if (!urlString.endsWith("/")) {
                urlString = urlString + "/";
            }
            this.url = new URL(urlString);
        } else {
            this.url = this.getBaseURL();
        }
    }

    private String formUserAgentHeader() {
        String header = null;
        StringBuilder stringBuilder = new StringBuilder("PayPalSDK/ID 0.5.2 ");
        stringBuilder.append("(").append(JAVAHEADER);
        String osVersion = OSHEADER;
        if (osVersion.length() > 0) {
            stringBuilder.append(";").append(osVersion);
        }
        stringBuilder.append(")");
        header = stringBuilder.toString();
        return header;
    }

    static {
        StringBuilder javaVersion = new StringBuilder("lang=Java");
        if (System.getProperty("java.version") != null && System.getProperty("java.version").length() > 0) {
            javaVersion.append(";V=").append(System.getProperty("java.version"));
        }
        if (System.getProperty("java.vm.name") != null && System.getProperty("java.vm.name").length() > 0) {
            javaVersion.append(";b=");
            if (System.getProperty("java.vm.name").contains("Client")) {
                javaVersion.append("32");
            } else {
                javaVersion.append("64");
            }
        }
        JAVAHEADER = javaVersion.toString();
        StringBuilder osVersion = new StringBuilder();
        if (System.getProperty("os.name") != null && System.getProperty("os.name").length() > 0) {
            osVersion.append("OS=");
            osVersion.append(System.getProperty("os.name").replace(' ', '_'));
        } else {
            osVersion.append("OS=");
        }
        if (System.getProperty("os.version") != null && System.getProperty("os.version").length() > 0) {
            osVersion.append(" " + System.getProperty("os.version").replace(' ', '_'));
        }
        OSHEADER = osVersion.toString();
    }
}

