/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Link;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.PaymentExecution;
import com.paypal.api.payments.PaymentHistory;
import com.paypal.api.payments.RedirectUrls;
import com.paypal.api.payments.Resource;
import com.paypal.api.payments.Transaction;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.QueryParameters;
import com.paypal.core.rest.RESTUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Payment
extends Resource {
    private String id;
    private String createTime;
    private String updateTime;
    private String state;
    private String intent;
    private Payer payer;
    private List<Transaction> transactions;
    private RedirectUrls redirectUrls;
    private List<Link> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static void initConfig(InputStream is) throws PayPalRESTException {
        PayPalResource.initConfig((InputStream)is);
    }

    public static void initConfig(File file) throws PayPalRESTException {
        PayPalResource.initConfig((File)file);
    }

    public static void initConfig(Properties properties) {
        PayPalResource.initConfig((Properties)properties);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getIntent() {
        return this.intent;
    }

    public void setIntent(String intent) {
        this.intent = intent;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public void setPayer(Payer payer) {
        this.payer = payer;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<Transaction> transactions) {
        this.transactions = transactions;
    }

    public RedirectUrls getRedirectUrls() {
        return this.redirectUrls;
    }

    public void setRedirectUrls(RedirectUrls redirectUrls) {
        this.redirectUrls = redirectUrls;
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public static PaymentHistory get(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        String pattern = "v1/payments/payment?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payee_id={5}&sort_by={6}&sort_order={7}";
        Object[] parameters = new Object[]{containerMap};
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        APIContext apiContext = new APIContext(accessToken);
        return (PaymentHistory)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, PaymentHistory.class);
    }

    public static PaymentHistory get(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        String pattern = "v1/payments/payment?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payee_id={5}&sort_by={6}&sort_order={7}";
        Object[] parameters = new Object[]{containerMap};
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null in APIContext");
        }
        return (PaymentHistory)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, PaymentHistory.class);
    }

    public static PaymentHistory get(String accessToken, QueryParameters queryParameters) throws PayPalRESTException {
        String pattern = "v1/payments/payment?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payee_id={5}&sort_by={6}&sort_order={7}";
        Object[] parameters = new Object[]{queryParameters};
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        APIContext apiContext = new APIContext(accessToken);
        return (PaymentHistory)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, PaymentHistory.class);
    }

    public static PaymentHistory get(APIContext apiContext, QueryParameters queryParameters) throws PayPalRESTException {
        String pattern = "v1/payments/payment?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payee_id={5}&sort_by={6}&sort_order={7}";
        Object[] parameters = new Object[]{queryParameters};
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null in APIContext");
        }
        return (PaymentHistory)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, PaymentHistory.class);
    }

    public Payment create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Payment create(APIContext apiContext) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        String resourcePath = "v1/payments/payment";
        String payLoad = this.toJSON();
        return (Payment)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Payment.class);
    }

    public static Payment get(String accessToken, String paymentId) throws PayPalRESTException {
        if (paymentId == null || paymentId.length() <= 0) {
            throw new IllegalArgumentException("paymentId cannot be null or empty");
        }
        String pattern = "v1/payments/payment/{0}";
        Object[] parameters = new Object[]{paymentId};
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        APIContext apiContext = new APIContext(accessToken);
        return (Payment)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Payment.class);
    }

    public static Payment get(APIContext apiContext, String paymentId) throws PayPalRESTException {
        if (paymentId == null || paymentId.length() <= 0) {
            throw new IllegalArgumentException("paymentId cannot be null or empty");
        }
        String pattern = "v1/payments/payment/{0}";
        Object[] parameters = new Object[]{paymentId};
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null in APIContext");
        }
        return (Payment)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Payment.class);
    }

    public Payment execute(String accessToken, PaymentExecution paymentExecution) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.execute(apiContext, paymentExecution);
    }

    public Payment execute(APIContext apiContext, PaymentExecution paymentExecution) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (paymentExecution == null) {
            throw new IllegalArgumentException("paymentExecution cannot be null");
        }
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        String pattern = "v1/payments/payment/{0}/execute";
        Object[] parameters = new Object[]{this.getId()};
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = paymentExecution.toJSON();
        return (Payment)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Payment.class);
    }

    @Override
    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    @Override
    public String toString() {
        return this.toJSON();
    }
}

