/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Capture;
import com.paypal.api.payments.Links;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Authorization {
    private String id;
    private String createTime;
    private String updateTime;
    private Amount amount;
    private String state;
    private String parentPayment;
    private String validUntil;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static void initConfig(InputStream is) throws PayPalRESTException {
        PayPalResource.initConfig((InputStream)is);
    }

    public static void initConfig(File file) throws PayPalRESTException {
        PayPalResource.initConfig((File)file);
    }

    public static void initConfig(Properties properties) {
        PayPalResource.initConfig((Properties)properties);
    }

    public Authorization setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Authorization setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Authorization setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Authorization setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Authorization setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Authorization setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public Authorization setValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public Authorization setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public static Authorization get(String accessToken, String authorizationId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Authorization.get(apiContext, authorizationId);
    }

    public static Authorization get(APIContext apiContext, String authorizationId) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (authorizationId == null) {
            throw new IllegalArgumentException("authorizationId cannot be null");
        }
        Object[] parameters = new Object[]{authorizationId};
        String pattern = "v1/payments/authorization/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Authorization)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, Authorization.class);
    }

    public Capture capture(String accessToken, Capture capture) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.capture(apiContext, capture);
    }

    public Capture capture(APIContext apiContext, Capture capture) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (capture == null) {
            throw new IllegalArgumentException("capture cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/capture";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = capture.toJSON();
        return (Capture)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Capture.class);
    }

    public Authorization doVoid(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.doVoid(apiContext);
    }

    public Authorization doVoid(APIContext apiContext) throws PayPalRESTException {
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/void";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (Authorization)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, Authorization.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

