/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Address;
import com.paypal.api.payments.CreditCardHistory;
import com.paypal.api.payments.Links;
import com.paypal.core.SDKVersion;
import com.paypal.core.rest.APIContext;
import com.paypal.core.rest.HttpMethod;
import com.paypal.core.rest.JSONFormatter;
import com.paypal.core.rest.PayPalRESTException;
import com.paypal.core.rest.PayPalResource;
import com.paypal.core.rest.RESTUtil;
import com.paypal.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreditCard {
    private String id;
    private String number;
    private String type;
    private int expireMonth;
    private int expireYear;
    private String cvv2;
    private String firstName;
    private String lastName;
    private Address billingAddress;
    private String payerId;
    private String state;
    private String validUntil;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static void initConfig(InputStream is) throws PayPalRESTException {
        PayPalResource.initConfig((InputStream)is);
    }

    public static void initConfig(File file) throws PayPalRESTException {
        PayPalResource.initConfig((File)file);
    }

    public static void initConfig(Properties properties) {
        PayPalResource.initConfig((Properties)properties);
    }

    public CreditCard() {
    }

    public CreditCard(String number, String type, int expireMonth, int expireYear) {
        this.number = number;
        this.type = type;
        this.expireMonth = expireMonth;
        this.expireYear = expireYear;
    }

    public CreditCard setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public CreditCard setNumber(String number) {
        this.number = number;
        return this;
    }

    public String getNumber() {
        return this.number;
    }

    public CreditCard setType(String type) {
        this.type = type;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CreditCard setExpireMonth(int expireMonth) {
        this.expireMonth = expireMonth;
        return this;
    }

    public int getExpireMonth() {
        return this.expireMonth;
    }

    public CreditCard setExpireYear(int expireYear) {
        this.expireYear = expireYear;
        return this;
    }

    public int getExpireYear() {
        return this.expireYear;
    }

    public CreditCard setCvv2(String cvv2) {
        this.cvv2 = cvv2;
        return this;
    }

    public String getCvv2() {
        return this.cvv2;
    }

    public CreditCard setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public CreditCard setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public String getLastName() {
        return this.lastName;
    }

    public CreditCard setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public CreditCard setPayerId(String payerId) {
        this.payerId = payerId;
        return this;
    }

    public String getPayerId() {
        return this.payerId;
    }

    public CreditCard setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public CreditCard setValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public CreditCard setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public CreditCard create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public CreditCard create(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        String resourcePath = "v1/vault/credit-card";
        String payLoad = this.toJSON();
        return (CreditCard)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.POST, (String)resourcePath, (String)payLoad, CreditCard.class);
    }

    public static CreditCard get(String accessToken, String creditCardId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return CreditCard.get(apiContext, creditCardId);
    }

    public static CreditCard get(APIContext apiContext, String creditCardId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (creditCardId == null) {
            throw new IllegalArgumentException("creditCardId cannot be null");
        }
        Object[] parameters = new Object[]{creditCardId};
        String pattern = "v1/vault/credit-card/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (CreditCard)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, CreditCard.class);
    }

    public void delete(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        apiContext.setMaskRequestId(true);
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/vault/credit-card/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.DELETE, (String)resourcePath, (String)payLoad, null);
    }

    public CreditCard update(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext);
    }

    public CreditCard update(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/vault/credit-card/{0}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = this.toJSON();
        return (CreditCard)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.PATCH, (String)resourcePath, (String)payLoad, CreditCard.class);
    }

    public static CreditCardHistory list(String accessToken, Map<String, String> containerMap) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return CreditCard.list(apiContext, containerMap);
    }

    public static CreditCardHistory list(APIContext apiContext, Map<String, String> containerMap) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion((SDKVersion)new SDKVersionImpl());
        if (containerMap == null) {
            throw new IllegalArgumentException("containerMap cannot be null");
        }
        Object[] parameters = new Object[]{containerMap};
        String pattern = "v1/vault/credit-card?count={0}&start_id={1}&start_index={2}&start_time={3}&end_time={4}&payer_id={5}";
        String resourcePath = RESTUtil.formatURIPath((String)pattern, (Object[])parameters);
        String payLoad = "";
        return (CreditCardHistory)PayPalResource.configureAndExecute((APIContext)apiContext, (HttpMethod)HttpMethod.GET, (String)resourcePath, (String)payLoad, CreditCardHistory.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON((Object)this);
    }

    public String toString() {
        return this.toJSON();
    }
}

