/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.soap;

import com.paypal.base.APICallPreHandler;
import com.paypal.base.CredentialManager;
import com.paypal.base.credential.CertificateCredential;
import com.paypal.base.credential.ICredential;
import com.paypal.base.credential.SignatureCredential;
import com.paypal.base.credential.TokenAuthorization;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.exception.InvalidCredentialException;
import com.paypal.base.exception.MissingCredentialException;
import com.paypal.base.exception.OAuthException;
import com.paypal.base.soap.CertificateHttpHeaderAuthStrategy;
import com.paypal.base.soap.CertificateSOAPHeaderAuthStrategy;
import com.paypal.base.soap.SignatureHttpHeaderAuthStrategy;
import com.paypal.base.soap.SignatureSOAPHeaderAuthStrategy;
import com.paypal.base.util.UserAgentHeader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MerchantAPICallPreHandler
implements APICallPreHandler {
    private static final Pattern REGEX_PATTERN = Pattern.compile("(['])");
    private String apiUserName;
    private ICredential credential;
    private String accessToken;
    private String tokenSecret;
    private APICallPreHandler apiCallHandler;
    private String sdkName;
    private String sdkVersion;
    private String portName;
    private Map<String, String> headers;
    private String payLoad;
    private Map<String, String> configurationMap = null;

    private MerchantAPICallPreHandler(APICallPreHandler apiCallHandler) {
        this.apiCallHandler = apiCallHandler;
    }

    private MerchantAPICallPreHandler(APICallPreHandler apiCallHandler, Map<String, String> configurationMap) {
        this.apiCallHandler = apiCallHandler;
        this.configurationMap = configurationMap;
    }

    public MerchantAPICallPreHandler(APICallPreHandler apiCallHandler, String apiUserName, String accessToken, String tokenSecret) throws InvalidCredentialException, MissingCredentialException {
        this(apiCallHandler);
        this.apiUserName = apiUserName;
        this.accessToken = accessToken;
        this.tokenSecret = tokenSecret;
        this.initCredential();
    }

    public MerchantAPICallPreHandler(APICallPreHandler apiCallHandler, ICredential credential) {
        this(apiCallHandler);
        if (credential == null) {
            throw new IllegalArgumentException("Credential is null in MerchantAPICallPreHandler");
        }
        this.credential = credential;
    }

    public MerchantAPICallPreHandler(APICallPreHandler apiCallHandler, ICredential credential, String sdkName, String sdkVersion, String portName, Map<String, String> configurationMap) {
        this(apiCallHandler, configurationMap);
        this.sdkName = sdkName;
        this.sdkVersion = sdkVersion;
        this.portName = portName;
        if (credential == null) {
            throw new IllegalArgumentException("Credential is null in MerchantAPICallPreHandler");
        }
        this.credential = credential;
    }

    public MerchantAPICallPreHandler(APICallPreHandler apiCallHandler, String apiUserName, String accessToken, String tokenSecret, String sdkName, String sdkVersion, String portName, Map<String, String> configurationMap) throws InvalidCredentialException, MissingCredentialException {
        this(apiCallHandler, configurationMap);
        this.apiUserName = apiUserName;
        this.accessToken = accessToken;
        this.tokenSecret = tokenSecret;
        this.sdkName = sdkName;
        this.sdkVersion = sdkVersion;
        this.portName = portName;
        this.initCredential();
    }

    public String getSdkName() {
        return this.sdkName;
    }

    public void setSdkName(String sdkName) {
        this.sdkName = sdkName;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    @Override
    public Map<String, String> getHeaderMap() throws OAuthException {
        if (this.headers == null) {
            this.headers = this.apiCallHandler.getHeaderMap();
            if (this.credential instanceof SignatureCredential) {
                SignatureHttpHeaderAuthStrategy signatureHttpHeaderAuthStrategy = new SignatureHttpHeaderAuthStrategy(this.getEndPoint());
                this.headers = signatureHttpHeaderAuthStrategy.generateHeaderStrategy((SignatureCredential)this.credential);
            } else if (this.credential instanceof CertificateCredential) {
                CertificateHttpHeaderAuthStrategy certificateHttpHeaderAuthStrategy = new CertificateHttpHeaderAuthStrategy(this.getEndPoint());
                this.headers = certificateHttpHeaderAuthStrategy.generateHeaderStrategy((CertificateCredential)this.credential);
            }
            this.headers.putAll(this.getDefaultHttpHeadersSOAP());
        }
        return this.headers;
    }

    @Override
    public String getPayLoad() {
        if (this.payLoad == null) {
            this.payLoad = this.apiCallHandler.getPayLoad();
            String header = null;
            if (this.credential instanceof SignatureCredential) {
                SignatureCredential sigCredential = (SignatureCredential)this.credential;
                SignatureSOAPHeaderAuthStrategy signatureSoapHeaderAuthStrategy = new SignatureSOAPHeaderAuthStrategy();
                signatureSoapHeaderAuthStrategy.setThirdPartyAuthorization(sigCredential.getThirdPartyAuthorization());
                header = signatureSoapHeaderAuthStrategy.generateHeaderStrategy(sigCredential);
            } else if (this.credential instanceof CertificateCredential) {
                CertificateCredential certCredential = (CertificateCredential)this.credential;
                CertificateSOAPHeaderAuthStrategy certificateSoapHeaderAuthStrategy = new CertificateSOAPHeaderAuthStrategy();
                certificateSoapHeaderAuthStrategy.setThirdPartyAuthorization(certCredential.getThirdPartyAuthorization());
                header = certificateSoapHeaderAuthStrategy.generateHeaderStrategy(certCredential);
            }
            this.payLoad = this.getPayLoadUsingSOAPHeader(this.payLoad, this.getNamespaces(), header);
        }
        return this.payLoad;
    }

    @Override
    public String getEndPoint() {
        String endPoint = this.searchEndpoint();
        if (endPoint == null) {
            if ("sandbox".equalsIgnoreCase(this.configurationMap.get("mode").trim())) {
                endPoint = this.getCredential() instanceof CertificateCredential ? "https://api.sandbox.paypal.com/2.0" : "https://api-3t.sandbox.paypal.com/2.0";
            } else if ("live".equalsIgnoreCase(this.configurationMap.get("mode").trim())) {
                endPoint = this.getCredential() instanceof CertificateCredential ? "https://api.paypal.com/2.0" : "https://api-3t.paypal.com/2.0";
            }
        }
        return endPoint;
    }

    @Override
    public ICredential getCredential() {
        return this.credential;
    }

    @Override
    public void validate() throws ClientActionRequiredException {
        String mode = this.configurationMap.get("mode");
        if (mode == null && this.searchEndpoint() == null) {
            throw new ClientActionRequiredException("mode[production/live] OR endpoint not specified");
        }
        if (mode != null && !mode.trim().equalsIgnoreCase("live") && !mode.trim().equalsIgnoreCase("sandbox")) {
            throw new ClientActionRequiredException("mode[production/live] OR endpoint not specified");
        }
    }

    private String searchEndpoint() {
        String endPoint;
        String string = this.configurationMap.get("service.EndPoint." + this.getPortName()) != null ? this.configurationMap.get("service.EndPoint." + this.getPortName()) : (endPoint = this.apiCallHandler.getEndPoint() != null ? this.apiCallHandler.getEndPoint() : null);
        if (endPoint != null && endPoint.trim().length() <= 0) {
            endPoint = null;
        }
        return endPoint;
    }

    private ICredential getCredentials() throws InvalidCredentialException, MissingCredentialException {
        ICredential returnCredential = null;
        CredentialManager credentialManager = new CredentialManager(this.configurationMap);
        returnCredential = credentialManager.getCredentialObject(this.apiUserName);
        if (this.accessToken != null && this.accessToken.trim().length() > 0) {
            TokenAuthorization tokenAuth = new TokenAuthorization(this.accessToken, this.tokenSecret);
            if (returnCredential instanceof SignatureCredential) {
                SignatureCredential sigCred = (SignatureCredential)returnCredential;
                sigCred.setThirdPartyAuthorization(tokenAuth);
            } else if (returnCredential instanceof CertificateCredential) {
                CertificateCredential certCred = (CertificateCredential)returnCredential;
                certCred.setThirdPartyAuthorization(tokenAuth);
            }
        }
        return returnCredential;
    }

    private Map<String, String> getDefaultHttpHeadersSOAP() {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("X-PAYPAL-REQUEST-DATA-FORMAT", "SOAP");
        returnMap.put("X-PAYPAL-RESPONSE-DATA-FORMAT", "SOAP");
        returnMap.put("X-PAYPAL-REQUEST-SOURCE", this.sdkName + "-" + this.sdkVersion);
        UserAgentHeader uaHeader = new UserAgentHeader(this.sdkName, this.sdkVersion);
        returnMap.putAll(uaHeader.getHeader());
        return returnMap;
    }

    private void initCredential() throws InvalidCredentialException, MissingCredentialException {
        if (this.credential == null) {
            this.credential = this.getCredentials();
        }
    }

    private String getNamespaces() {
        return "xmlns:ns=\"urn:ebay:api:PayPalAPI\" xmlns:ebl=\"urn:ebay:apis:eBLBaseComponents\" xmlns:cc=\"urn:ebay:apis:CoreComponentTypes\" xmlns:ed=\"urn:ebay:apis:EnhancedDataTypes\"";
    }

    private String getPayLoadUsingSOAPHeader(String payLoad, String namespace, String header) {
        String returnPayLoad = null;
        String formattedPayLoad = this.processPayLoadForFormatting(payLoad);
        returnPayLoad = MessageFormat.format(formattedPayLoad, namespace, header);
        return returnPayLoad;
    }

    private String processPayLoadForFormatting(String payLoad) {
        Matcher match = REGEX_PATTERN.matcher(payLoad);
        StringBuffer sb = new StringBuffer();
        while (match.find()) {
            match.appendReplacement(sb, "'" + match.group());
        }
        match.appendTail(sb);
        return sb.toString().replaceAll("(?<!\\{[01]{1})}", "'}' ").replaceAll("\\{(?![01]})", "'{' ");
    }
}

