/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.google.gson.GsonBuilder;
import com.paypal.api.payments.Address;
import com.paypal.api.payments.AgreementDetails;
import com.paypal.api.payments.AgreementStateDescriptor;
import com.paypal.api.payments.AgreementTransactions;
import com.paypal.api.payments.Currency;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.MerchantPreferences;
import com.paypal.api.payments.OverrideChargeModel;
import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.Plan;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.OAuthTokenCredential;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Agreement {
    private String id;
    private String state;
    private String name;
    private String description;
    private String startDate;
    private AgreementDetails agreementDetails;
    private Payer payer;
    private Address shippingAddress;
    private MerchantPreferences overrideMerchantPreferences;
    private List<OverrideChargeModel> overrideChargeModels;
    private Plan plan;
    private String createTime;
    private String updateTime;
    private String token;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static OAuthTokenCredential initConfig(InputStream is) throws PayPalRESTException {
        return PayPalResource.initConfig(is);
    }

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        return PayPalResource.initConfig(file);
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        return PayPalResource.initConfig(properties);
    }

    public Agreement() {
    }

    public Agreement(String name, String description, String startDate, Payer payer, Plan plan) {
        this.name = name;
        this.description = description;
        this.startDate = startDate;
        this.payer = payer;
        this.plan = plan;
    }

    public Agreement setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Agreement setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Agreement setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Agreement setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Agreement setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public Agreement setAgreementDetails(AgreementDetails agreementDetails) {
        this.agreementDetails = agreementDetails;
        return this;
    }

    public AgreementDetails getAgreementDetails() {
        return this.agreementDetails;
    }

    public Agreement setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Agreement setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public Agreement setOverrideMerchantPreferences(MerchantPreferences overrideMerchantPreferences) {
        this.overrideMerchantPreferences = overrideMerchantPreferences;
        return this;
    }

    public MerchantPreferences getOverrideMerchantPreferences() {
        return this.overrideMerchantPreferences;
    }

    public Agreement setOverrideChargeModels(List<OverrideChargeModel> overrideChargeModels) {
        this.overrideChargeModels = overrideChargeModels;
        return this;
    }

    public List<OverrideChargeModel> getOverrideChargeModels() {
        return this.overrideChargeModels;
    }

    public Agreement setPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public Agreement setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Agreement setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Agreement setToken(String token) {
        this.token = token;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public Agreement setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Agreement create(String accessToken) throws PayPalRESTException, MalformedURLException, UnsupportedEncodingException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Agreement create(APIContext apiContext) throws PayPalRESTException, MalformedURLException, UnsupportedEncodingException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String resourcePath = "v1/payments/billing-agreements";
        String payLoad = this.toJSON();
        Agreement agreement = PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Agreement.class);
        for (Links links : agreement.getLinks()) {
            if (!"approval_url".equals(links.getRel())) continue;
            URL url = new URL(links.getHref());
            agreement.setToken(Agreement.splitQuery(url).get("token"));
            break;
        }
        return agreement;
    }

    private static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return queryPairs;
    }

    public Agreement execute(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.execute(apiContext);
    }

    public Agreement execute(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        Object[] parameters = new Object[]{this.token};
        String pattern = "v1/payments/billing-agreements/{0}/agreement-execute";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Agreement.class);
    }

    public static Agreement get(String accessToken, String agreementId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Agreement.get(apiContext, agreementId);
    }

    public static Agreement get(APIContext apiContext, String agreementId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (agreementId == null) {
            throw new IllegalArgumentException("agreementId cannot be null");
        }
        Object[] parameters = new Object[]{agreementId};
        String pattern = "v1/payments/billing-agreements/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Agreement.class);
    }

    public Agreement update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext, patchRequest);
    }

    public Agreement update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = new GsonBuilder().create().toJson(patchRequest);
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, Agreement.class);
    }

    public void suspend(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.suspend(apiContext, agreementStateDescriptor);
    }

    public void suspend(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/suspend";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void reActivate(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.reActivate(apiContext, agreementStateDescriptor);
    }

    public void reActivate(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/re-activate";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void cancel(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.cancel(apiContext, agreementStateDescriptor);
    }

    public void cancel(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/cancel";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void billBalance(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.billBalance(apiContext, agreementStateDescriptor);
    }

    public void billBalance(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/bill-balance";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void setBalance(String accessToken, Currency currency) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.setBalance(apiContext, currency);
    }

    public void setBalance(APIContext apiContext, Currency currency) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (currency == null) {
            throw new IllegalArgumentException("currency cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/set-balance";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = currency.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public static AgreementTransactions transactions(String accessToken, String agreementId, Date startDate, Date endDate) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Agreement.transactions(apiContext, agreementId, startDate, endDate);
    }

    public static AgreementTransactions transactions(APIContext apiContext, String agreementId, Date startDate, Date endDate) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        if (startDate == null) {
            throw new IllegalArgumentException("startDate cannot be null");
        }
        if (endDate == null) {
            throw new IllegalArgumentException("endDate cannot be null");
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (agreementId == null) {
            throw new IllegalArgumentException("agreementId cannot be null");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = dateFormat.format(startDate);
        String eDate = dateFormat.format(endDate);
        Object[] parameters = new Object[]{agreementId, sDate, eDate};
        String pattern = "v1/payments/billing-agreements/{0}/transactions?start_date={1}&end_date={2}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, AgreementTransactions.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON(this);
    }

    public String toString() {
        return this.toJSON();
    }
}

