/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.EventList;
import com.paypal.api.payments.Links;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event {
    private String id;
    private String createTime;
    private String resourceType;
    private String eventType;
    private String summary;
    private Object resource;
    private List<Links> links;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static void initConfig(InputStream is) throws PayPalRESTException {
        PayPalResource.initConfig(is);
    }

    public static void initConfig(File file) throws PayPalRESTException {
        PayPalResource.initConfig(file);
    }

    public static void initConfig(Properties properties) {
        PayPalResource.initConfig(properties);
    }

    public Event setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Event setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Event setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Event setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Event setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Event setResource(Object resource) {
        this.resource = resource;
        return this;
    }

    public Object getResource() {
        return this.resource;
    }

    public Event setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public static Event get(String accessToken, String eventId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Event.get(apiContext, eventId);
    }

    public static Event get(APIContext apiContext, String eventId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (eventId == null) {
            throw new IllegalArgumentException("eventId cannot be null");
        }
        Object[] parameters = new Object[]{eventId};
        String pattern = "v1/notifications/webhooks-events/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Event.class);
    }

    public Event resend(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.resend(apiContext);
    }

    public Event resend(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/notifications/webhooks-events/{0}/resend";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Event.class);
    }

    public static EventList list(String accessToken, String queryParams) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Event.list(apiContext, queryParams);
    }

    public static EventList list(APIContext apiContext, String queryParams) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String resourcePath = "v1/notifications/webhooks-events" + queryParams;
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, EventList.class);
    }

    public String toJSON() {
        return JSONFormatter.toJSON(this);
    }

    public String toString() {
        return this.toJSON();
    }
}

