/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.BillingInfo;
import com.paypal.api.payments.CancelNotification;
import com.paypal.api.payments.Cost;
import com.paypal.api.payments.Currency;
import com.paypal.api.payments.CustomAmount;
import com.paypal.api.payments.InvoiceItem;
import com.paypal.api.payments.Invoices;
import com.paypal.api.payments.MerchantInfo;
import com.paypal.api.payments.Metadata;
import com.paypal.api.payments.Notification;
import com.paypal.api.payments.PaymentDetail;
import com.paypal.api.payments.PaymentTerm;
import com.paypal.api.payments.RefundDetail;
import com.paypal.api.payments.Search;
import com.paypal.api.payments.ShippingCost;
import com.paypal.api.payments.ShippingInfo;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.OAuthTokenCredential;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invoice {
    private String id;
    private String number;
    private String uri;
    private String status;
    private MerchantInfo merchantInfo;
    private List<BillingInfo> billingInfo;
    private ShippingInfo shippingInfo;
    private List<InvoiceItem> items;
    private String invoiceDate;
    private PaymentTerm paymentTerm;
    private Cost discount;
    private ShippingCost shippingCost;
    private CustomAmount custom;
    private Boolean taxCalculatedAfterDiscount;
    private Boolean taxInclusive;
    private String terms;
    private String note;
    private String merchantMemo;
    private String logoUrl;
    private Currency totalAmount;
    private List<PaymentDetail> paymentDetails;
    private List<RefundDetail> refundDetails;
    private Metadata metadata;

    public static String getLastRequest() {
        return PayPalResource.getLastRequest();
    }

    public static String getLastResponse() {
        return PayPalResource.getLastResponse();
    }

    public static OAuthTokenCredential initConfig(InputStream is) throws PayPalRESTException {
        return PayPalResource.initConfig(is);
    }

    public static OAuthTokenCredential initConfig(File file) throws PayPalRESTException {
        return PayPalResource.initConfig(file);
    }

    public static OAuthTokenCredential initConfig(Properties properties) {
        return PayPalResource.initConfig(properties);
    }

    public Invoice() {
    }

    public Invoice(MerchantInfo merchantInfo) {
        this.merchantInfo = merchantInfo;
    }

    public Invoice setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Invoice setNumber(String number) {
        this.number = number;
        return this;
    }

    public String getNumber() {
        return this.number;
    }

    public Invoice setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public Invoice setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public Invoice setMerchantInfo(MerchantInfo merchantInfo) {
        this.merchantInfo = merchantInfo;
        return this;
    }

    public MerchantInfo getMerchantInfo() {
        return this.merchantInfo;
    }

    public Invoice setBillingInfo(List<BillingInfo> billingInfo) {
        this.billingInfo = billingInfo;
        return this;
    }

    public List<BillingInfo> getBillingInfo() {
        return this.billingInfo;
    }

    public Invoice setShippingInfo(ShippingInfo shippingInfo) {
        this.shippingInfo = shippingInfo;
        return this;
    }

    public ShippingInfo getShippingInfo() {
        return this.shippingInfo;
    }

    public Invoice setItems(List<InvoiceItem> items) {
        this.items = items;
        return this;
    }

    public List<InvoiceItem> getItems() {
        return this.items;
    }

    public Invoice setInvoiceDate(String invoiceDate) {
        this.invoiceDate = invoiceDate;
        return this;
    }

    public String getInvoiceDate() {
        return this.invoiceDate;
    }

    public Invoice setPaymentTerm(PaymentTerm paymentTerm) {
        this.paymentTerm = paymentTerm;
        return this;
    }

    public PaymentTerm getPaymentTerm() {
        return this.paymentTerm;
    }

    public Invoice setDiscount(Cost discount) {
        this.discount = discount;
        return this;
    }

    public Cost getDiscount() {
        return this.discount;
    }

    public Invoice setShippingCost(ShippingCost shippingCost) {
        this.shippingCost = shippingCost;
        return this;
    }

    public ShippingCost getShippingCost() {
        return this.shippingCost;
    }

    public Invoice setCustom(CustomAmount custom) {
        this.custom = custom;
        return this;
    }

    public CustomAmount getCustom() {
        return this.custom;
    }

    public Invoice setTaxCalculatedAfterDiscount(Boolean taxCalculatedAfterDiscount) {
        this.taxCalculatedAfterDiscount = taxCalculatedAfterDiscount;
        return this;
    }

    public Boolean getTaxCalculatedAfterDiscount() {
        return this.taxCalculatedAfterDiscount;
    }

    public Invoice setTaxInclusive(Boolean taxInclusive) {
        this.taxInclusive = taxInclusive;
        return this;
    }

    public Boolean getTaxInclusive() {
        return this.taxInclusive;
    }

    public Invoice setTerms(String terms) {
        this.terms = terms;
        return this;
    }

    public String getTerms() {
        return this.terms;
    }

    public Invoice setNote(String note) {
        this.note = note;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public Invoice setMerchantMemo(String merchantMemo) {
        this.merchantMemo = merchantMemo;
        return this;
    }

    public String getMerchantMemo() {
        return this.merchantMemo;
    }

    public Invoice setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public Invoice setTotalAmount(Currency totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    public Currency getTotalAmount() {
        return this.totalAmount;
    }

    public Invoice setPaymentDetails(List<PaymentDetail> paymentDetails) {
        this.paymentDetails = paymentDetails;
        return this;
    }

    public List<PaymentDetail> getPaymentDetails() {
        return this.paymentDetails;
    }

    public Invoice setRefundDetails(List<RefundDetail> refundDetails) {
        this.refundDetails = refundDetails;
        return this;
    }

    public List<RefundDetail> getRefundDetails() {
        return this.refundDetails;
    }

    public Invoice setMetadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Invoice create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Invoice create(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String resourcePath = "v1/invoicing/invoices";
        String payLoad = this.toJSON();
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Invoice.class);
    }

    public Invoices search(String accessToken, Search search) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.search(apiContext, search);
    }

    public Invoices search(APIContext apiContext, Search search) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (search == null) {
            throw new IllegalArgumentException("search cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/search";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = search.toJSON();
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Invoices.class);
    }

    public void send(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.send(apiContext);
    }

    public void send(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/send";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void remind(String accessToken, Notification notification) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.remind(apiContext, notification);
    }

    public void remind(APIContext apiContext, Notification notification) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (notification == null) {
            throw new IllegalArgumentException("notification cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/remind";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = notification.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void cancel(String accessToken, CancelNotification cancelNotification) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.cancel(apiContext, cancelNotification);
    }

    public void cancel(APIContext apiContext, CancelNotification cancelNotification) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (cancelNotification == null) {
            throw new IllegalArgumentException("cancelNotification cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/cancel";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = cancelNotification.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void recordPayment(String accessToken, PaymentDetail paymentDetail) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.recordPayment(apiContext, paymentDetail);
    }

    public void recordPayment(APIContext apiContext, PaymentDetail paymentDetail) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (paymentDetail == null) {
            throw new IllegalArgumentException("paymentDetail cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/record-payment";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = paymentDetail.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void recordRefund(String accessToken, RefundDetail refundDetail) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.recordRefund(apiContext, refundDetail);
    }

    public void recordRefund(APIContext apiContext, RefundDetail refundDetail) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (refundDetail == null) {
            throw new IllegalArgumentException("refundDetail cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}/record-refund";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = refundDetail.toJSON();
        PayPalResource.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public static Invoice get(String accessToken, String invoiceId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Invoice.get(apiContext, invoiceId);
    }

    public static Invoice get(APIContext apiContext, String invoiceId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (invoiceId == null) {
            throw new IllegalArgumentException("invoiceId cannot be null");
        }
        Object[] parameters = new Object[]{invoiceId};
        String pattern = "v1/invoicing/invoices/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Invoice.class);
    }

    public static Invoices getAll(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Invoice.getAll(apiContext);
    }

    public static Invoices getAll(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String resourcePath = "v1/invoicing/invoices";
        String payLoad = "";
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Invoices.class);
    }

    public Invoice update(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext);
    }

    public Invoice update(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = this.toJSON();
        return PayPalResource.configureAndExecute(apiContext, HttpMethod.PUT, resourcePath, payLoad, Invoice.class);
    }

    public void delete(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        apiContext.setMaskRequestId(true);
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/invoicing/invoices/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        PayPalResource.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
    }

    public String toJSON() {
        return JSONFormatter.toJSON(this);
    }

    public String toString() {
        return this.toJSON();
    }
}

