/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.soap;

import com.paypal.base.AuthenticationStrategy;
import com.paypal.base.credential.CertificateCredential;
import com.paypal.base.credential.SubjectAuthorization;
import com.paypal.base.credential.ThirdPartyAuthorization;
import com.paypal.base.credential.TokenAuthorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateSOAPHeaderAuthStrategy
implements AuthenticationStrategy<String, CertificateCredential> {
    private ThirdPartyAuthorization thirdPartyAuthorization;

    public ThirdPartyAuthorization getThirdPartyAuthorization() {
        return this.thirdPartyAuthorization;
    }

    public void setThirdPartyAuthorization(ThirdPartyAuthorization thirdPartyAuthorization) {
        this.thirdPartyAuthorization = thirdPartyAuthorization;
    }

    @Override
    public String generateHeaderStrategy(CertificateCredential credential) {
        String payLoad = null;
        payLoad = this.thirdPartyAuthorization instanceof TokenAuthorization ? this.tokenAuthPayLoad() : (this.thirdPartyAuthorization instanceof SubjectAuthorization ? this.authPayLoad(credential, (SubjectAuthorization)this.thirdPartyAuthorization) : this.authPayLoad(credential, null));
        return payLoad;
    }

    private String tokenAuthPayLoad() {
        StringBuilder soapMsg = new StringBuilder();
        soapMsg.append("<ns:RequesterCredentials/>");
        return soapMsg.toString();
    }

    private String authPayLoad(CertificateCredential credential, SubjectAuthorization subjectAuth) {
        StringBuilder soapMsg = new StringBuilder();
        soapMsg.append("<ns:RequesterCredentials>");
        soapMsg.append("<ebl:Credentials>");
        soapMsg.append("<ebl:Username>" + credential.getUserName() + "</ebl:Username>");
        soapMsg.append("<ebl:Password>" + credential.getPassword() + "</ebl:Password>");
        if (subjectAuth != null) {
            soapMsg.append("<ebl:Subject>" + subjectAuth.getSubject() + "</ebl:Subject>");
        }
        soapMsg.append("</ebl:Credentials>");
        soapMsg.append("</ns:RequesterCredentials>");
        return soapMsg.toString();
    }
}

