// Generated by delombok at Wed Oct 12 18:15:55 CDT 2016
package com.paypal.api.payments;

import com.paypal.base.rest.*;
import java.util.List;

public class Refund extends PayPalResource {
	/**
	 * ID of the refund transaction. 17 characters max.
	 */
	private String id;
	/**
	 * Details including both refunded amount (to payer) and refunded fee (to payee). 10 characters max.
	 */
	private Amount amount;
	/**
	 * State of the refund.
	 */
	private String state;
	/**
	 * Reason description for the Sale transaction being refunded.
	 */
	private String reason;
	/**
	 * ID of the Sale transaction being refunded.
	 */
	private String saleId;
	/**
	 * ID of the sale transaction being refunded.
	 */
	private String captureId;
	/**
	 * ID of the payment resource on which this transaction is based.
	 */
	private String parentPayment;
	/**
	 * Description of what is being refunded for.
	 */
	private String description;
	/**
	 * Time of refund as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	private String createTime;
	/**
	 * Time that the resource was last updated.
	 */
	private String updateTime;
	/**
	 */
	private List<Links> links;

	/**
	 * Default Constructor
	 */
	public Refund() {
	}

	/**
	 * Obtain the Refund transaction resource for the given identifier.
	 * @deprecated Please use {@link #get(APIContext, String)} instead.
	 *
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param refundId
	 * String
	 * @return Refund
	 * @throws PayPalRESTException
	 */
	public static Refund get(String accessToken, String refundId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return get(apiContext, refundId);
	}

	/**
	 * Obtain the Refund transaction resource for the given identifier.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param refundId
	 * String
	 * @return Refund
	 * @throws PayPalRESTException
	 */
	public static Refund get(APIContext apiContext, String refundId) throws PayPalRESTException {
		if (refundId == null) {
			throw new IllegalArgumentException("refundId cannot be null");
		}
		Object[] parameters = new Object[] {refundId};
		String pattern = "v1/payments/refund/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Refund.class);
	}

	/**
	 * ID of the refund transaction. 17 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Details including both refunded amount (to payer) and refunded fee (to payee). 10 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public Amount getAmount() {
		return this.amount;
	}

	/**
	 * State of the refund.
	 */
	@java.lang.SuppressWarnings("all")
	public String getState() {
		return this.state;
	}

	/**
	 * Reason description for the Sale transaction being refunded.
	 */
	@java.lang.SuppressWarnings("all")
	public String getReason() {
		return this.reason;
	}

	/**
	 * ID of the Sale transaction being refunded.
	 */
	@java.lang.SuppressWarnings("all")
	public String getSaleId() {
		return this.saleId;
	}

	/**
	 * ID of the sale transaction being refunded.
	 */
	@java.lang.SuppressWarnings("all")
	public String getCaptureId() {
		return this.captureId;
	}

	/**
	 * ID of the payment resource on which this transaction is based.
	 */
	@java.lang.SuppressWarnings("all")
	public String getParentPayment() {
		return this.parentPayment;
	}

	/**
	 * Description of what is being refunded for.
	 */
	@java.lang.SuppressWarnings("all")
	public String getDescription() {
		return this.description;
	}

	/**
	 * Time of refund as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	@java.lang.SuppressWarnings("all")
	public String getCreateTime() {
		return this.createTime;
	}

	/**
	 * Time that the resource was last updated.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUpdateTime() {
		return this.updateTime;
	}

	/**
	 */
	@java.lang.SuppressWarnings("all")
	public List<Links> getLinks() {
		return this.links;
	}

	/**
	 * ID of the refund transaction. 17 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Details including both refunded amount (to payer) and refunded fee (to payee). 10 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setAmount(final Amount amount) {
		this.amount = amount;
		return this;
	}

	/**
	 * State of the refund.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setState(final String state) {
		this.state = state;
		return this;
	}

	/**
	 * Reason description for the Sale transaction being refunded.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setReason(final String reason) {
		this.reason = reason;
		return this;
	}

	/**
	 * ID of the Sale transaction being refunded.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setSaleId(final String saleId) {
		this.saleId = saleId;
		return this;
	}

	/**
	 * ID of the sale transaction being refunded.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setCaptureId(final String captureId) {
		this.captureId = captureId;
		return this;
	}

	/**
	 * ID of the payment resource on which this transaction is based.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setParentPayment(final String parentPayment) {
		this.parentPayment = parentPayment;
		return this;
	}

	/**
	 * Description of what is being refunded for.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setDescription(final String description) {
		this.description = description;
		return this;
	}

	/**
	 * Time of refund as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setCreateTime(final String createTime) {
		this.createTime = createTime;
		return this;
	}

	/**
	 * Time that the resource was last updated.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setUpdateTime(final String updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	/**
	 *
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Refund setLinks(final List<Links> links) {
		this.links = links;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof Refund)) return false;
		final Refund other = (Refund) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$amount = this.getAmount();
		final java.lang.Object other$amount = other.getAmount();
		if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
		final java.lang.Object this$state = this.getState();
		final java.lang.Object other$state = other.getState();
		if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
		final java.lang.Object this$reason = this.getReason();
		final java.lang.Object other$reason = other.getReason();
		if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) return false;
		final java.lang.Object this$saleId = this.getSaleId();
		final java.lang.Object other$saleId = other.getSaleId();
		if (this$saleId == null ? other$saleId != null : !this$saleId.equals(other$saleId)) return false;
		final java.lang.Object this$captureId = this.getCaptureId();
		final java.lang.Object other$captureId = other.getCaptureId();
		if (this$captureId == null ? other$captureId != null : !this$captureId.equals(other$captureId)) return false;
		final java.lang.Object this$parentPayment = this.getParentPayment();
		final java.lang.Object other$parentPayment = other.getParentPayment();
		if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) return false;
		final java.lang.Object this$description = this.getDescription();
		final java.lang.Object other$description = other.getDescription();
		if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
		final java.lang.Object this$createTime = this.getCreateTime();
		final java.lang.Object other$createTime = other.getCreateTime();
		if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) return false;
		final java.lang.Object this$updateTime = this.getUpdateTime();
		final java.lang.Object other$updateTime = other.getUpdateTime();
		if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) return false;
		final java.lang.Object this$links = this.getLinks();
		final java.lang.Object other$links = other.getLinks();
		if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof Refund;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $amount = this.getAmount();
		result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
		final java.lang.Object $state = this.getState();
		result = result * PRIME + ($state == null ? 43 : $state.hashCode());
		final java.lang.Object $reason = this.getReason();
		result = result * PRIME + ($reason == null ? 43 : $reason.hashCode());
		final java.lang.Object $saleId = this.getSaleId();
		result = result * PRIME + ($saleId == null ? 43 : $saleId.hashCode());
		final java.lang.Object $captureId = this.getCaptureId();
		result = result * PRIME + ($captureId == null ? 43 : $captureId.hashCode());
		final java.lang.Object $parentPayment = this.getParentPayment();
		result = result * PRIME + ($parentPayment == null ? 43 : $parentPayment.hashCode());
		final java.lang.Object $description = this.getDescription();
		result = result * PRIME + ($description == null ? 43 : $description.hashCode());
		final java.lang.Object $createTime = this.getCreateTime();
		result = result * PRIME + ($createTime == null ? 43 : $createTime.hashCode());
		final java.lang.Object $updateTime = this.getUpdateTime();
		result = result * PRIME + ($updateTime == null ? 43 : $updateTime.hashCode());
		final java.lang.Object $links = this.getLinks();
		result = result * PRIME + ($links == null ? 43 : $links.hashCode());
		return result;
	}
}
