// Generated by delombok at Fri Oct 14 18:54:14 CDT 2016
package com.paypal.api.payments;

import com.paypal.base.rest.PayPalModel;

public class InvoiceItem extends PayPalModel {
	/**
	 * Name of the item. 200 characters max.
	 */
	private String name;
	/**
	 * Description of the item. 1000 characters max.
	 */
	private String description;
	/**
	 * Quantity of the item. Range of -10000 to 10000.
	 */
	private float quantity;
	/**
	 * Unit price of the item. Range of -1,000,000 to 1,000,000.
	 */
	private Currency unitPrice;
	/**
	 * Tax associated with the item.
	 */
	private Tax tax;
	/**
	 * The date when the item or service was provided. The date format is *yyyy*-*MM*-*dd* *z* as defined in [Internet Date/Time Format](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	private String date;
	/**
	 * The item discount, as a percent or an amount value.
	 */
	private Cost discount;
	/**
	 * The image URL. Maximum length is 4000 characters.
	 */
	private String imageUrl;
	/**
	 * The unit of measure of the item being invoiced.
	 */
	private String unitOfMeasure;

	/**
	 * Default Constructor
	 */
	public InvoiceItem() {
	}

	/**
	 * Parameterized Constructor
	 */
	public InvoiceItem(String name, float quantity, Currency unitPrice) {
		this.name = name;
		this.quantity = quantity;
		this.unitPrice = unitPrice;
	}

	/**
	 * Name of the item. 200 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getName() {
		return this.name;
	}

	/**
	 * Description of the item. 1000 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getDescription() {
		return this.description;
	}

	/**
	 * Quantity of the item. Range of -10000 to 10000.
	 */
	@java.lang.SuppressWarnings("all")
	public float getQuantity() {
		return this.quantity;
	}

	/**
	 * Unit price of the item. Range of -1,000,000 to 1,000,000.
	 */
	@java.lang.SuppressWarnings("all")
	public Currency getUnitPrice() {
		return this.unitPrice;
	}

	/**
	 * Tax associated with the item.
	 */
	@java.lang.SuppressWarnings("all")
	public Tax getTax() {
		return this.tax;
	}

	/**
	 * The date when the item or service was provided. The date format is *yyyy*-*MM*-*dd* *z* as defined in [Internet Date/Time Format](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	@java.lang.SuppressWarnings("all")
	public String getDate() {
		return this.date;
	}

	/**
	 * The item discount, as a percent or an amount value.
	 */
	@java.lang.SuppressWarnings("all")
	public Cost getDiscount() {
		return this.discount;
	}

	/**
	 * The image URL. Maximum length is 4000 characters.
	 */
	@java.lang.SuppressWarnings("all")
	public String getImageUrl() {
		return this.imageUrl;
	}

	/**
	 * The unit of measure of the item being invoiced.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUnitOfMeasure() {
		return this.unitOfMeasure;
	}

	/**
	 * Name of the item. 200 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setName(final String name) {
		this.name = name;
		return this;
	}

	/**
	 * Description of the item. 1000 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setDescription(final String description) {
		this.description = description;
		return this;
	}

	/**
	 * Quantity of the item. Range of -10000 to 10000.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setQuantity(final float quantity) {
		this.quantity = quantity;
		return this;
	}

	/**
	 * Unit price of the item. Range of -1,000,000 to 1,000,000.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setUnitPrice(final Currency unitPrice) {
		this.unitPrice = unitPrice;
		return this;
	}

	/**
	 * Tax associated with the item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setTax(final Tax tax) {
		this.tax = tax;
		return this;
	}

	/**
	 * The date when the item or service was provided. The date format is *yyyy*-*MM*-*dd* *z* as defined in [Internet Date/Time Format](http://tools.ietf.org/html/rfc3339#section-5.6).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setDate(final String date) {
		this.date = date;
		return this;
	}

	/**
	 * The item discount, as a percent or an amount value.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setDiscount(final Cost discount) {
		this.discount = discount;
		return this;
	}

	/**
	 * The image URL. Maximum length is 4000 characters.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setImageUrl(final String imageUrl) {
		this.imageUrl = imageUrl;
		return this;
	}

	/**
	 * The unit of measure of the item being invoiced.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setUnitOfMeasure(final String unitOfMeasure) {
		this.unitOfMeasure = unitOfMeasure;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof InvoiceItem)) return false;
		final InvoiceItem other = (InvoiceItem) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$name = this.getName();
		final java.lang.Object other$name = other.getName();
		if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
		final java.lang.Object this$description = this.getDescription();
		final java.lang.Object other$description = other.getDescription();
		if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
		if (java.lang.Float.compare(this.getQuantity(), other.getQuantity()) != 0) return false;
		final java.lang.Object this$unitPrice = this.getUnitPrice();
		final java.lang.Object other$unitPrice = other.getUnitPrice();
		if (this$unitPrice == null ? other$unitPrice != null : !this$unitPrice.equals(other$unitPrice)) return false;
		final java.lang.Object this$tax = this.getTax();
		final java.lang.Object other$tax = other.getTax();
		if (this$tax == null ? other$tax != null : !this$tax.equals(other$tax)) return false;
		final java.lang.Object this$date = this.getDate();
		final java.lang.Object other$date = other.getDate();
		if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
		final java.lang.Object this$discount = this.getDiscount();
		final java.lang.Object other$discount = other.getDiscount();
		if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
		final java.lang.Object this$imageUrl = this.getImageUrl();
		final java.lang.Object other$imageUrl = other.getImageUrl();
		if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) return false;
		final java.lang.Object this$unitOfMeasure = this.getUnitOfMeasure();
		final java.lang.Object other$unitOfMeasure = other.getUnitOfMeasure();
		if (this$unitOfMeasure == null ? other$unitOfMeasure != null : !this$unitOfMeasure.equals(other$unitOfMeasure)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof InvoiceItem;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $name = this.getName();
		result = result * PRIME + ($name == null ? 43 : $name.hashCode());
		final java.lang.Object $description = this.getDescription();
		result = result * PRIME + ($description == null ? 43 : $description.hashCode());
		result = result * PRIME + java.lang.Float.floatToIntBits(this.getQuantity());
		final java.lang.Object $unitPrice = this.getUnitPrice();
		result = result * PRIME + ($unitPrice == null ? 43 : $unitPrice.hashCode());
		final java.lang.Object $tax = this.getTax();
		result = result * PRIME + ($tax == null ? 43 : $tax.hashCode());
		final java.lang.Object $date = this.getDate();
		result = result * PRIME + ($date == null ? 43 : $date.hashCode());
		final java.lang.Object $discount = this.getDiscount();
		result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
		final java.lang.Object $imageUrl = this.getImageUrl();
		result = result * PRIME + ($imageUrl == null ? 43 : $imageUrl.hashCode());
		final java.lang.Object $unitOfMeasure = this.getUnitOfMeasure();
		result = result * PRIME + ($unitOfMeasure == null ? 43 : $unitOfMeasure.hashCode());
		return result;
	}
}
