// Generated by delombok at Tue Nov 01 13:40:02 CDT 2016
package com.paypal.api.payments;

import com.paypal.base.rest.*;
import java.util.List;

public class Capture extends PayPalResource {
	/**
	 * ID of the capture transaction.
	 */
	private String id;
	/**
	 * Amount being captured. If the amount matches the orginally authorized amount, the state of the authorization changes to `captured`. If not, the state of the authorization changes to `partially_captured`.
	 */
	private Amount amount;
	/**
	 * If set to `true`, all remaining funds held by the authorization will be released in the funding instrument.
	 */
	private Boolean isFinalCapture;
	/**
	 * State of the capture.
	 */
	private String state;
	/**
	 * ID of the payment resource on which this transaction is based.
	 */
	private String parentPayment;
	/**
	 * Transaction fee applicable for this payment.
	 */
	private Currency transactionFee;
	/**
	 * Time of capture as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	private String createTime;
	/**
	 * Time that the resource was last updated.
	 */
	private String updateTime;
	/**
	 */
	private List<Links> links;

	/**
	 * Default Constructor
	 */
	public Capture() {
	}

	/**
	 * Obtain the Capture transaction resource for the given identifier.
	 * @deprecated Please use {@link #get(APIContext, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param captureId
	 * String
	 * @return Capture
	 * @throws PayPalRESTException
	 */
	public static Capture get(String accessToken, String captureId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return get(apiContext, captureId);
	}

	/**
	 * Obtain the Capture transaction resource for the given identifier.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param captureId
	 * String
	 * @return Capture
	 * @throws PayPalRESTException
	 */
	public static Capture get(APIContext apiContext, String captureId) throws PayPalRESTException {
		if (captureId == null) {
			throw new IllegalArgumentException("captureId cannot be null");
		}
		Object[] parameters = new Object[] {captureId};
		String pattern = "v1/payments/capture/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Capture.class);
	}

	/**
	 * Creates (and processes) a new Refund Transaction added as a related resource.
	 * @deprecated Please use {@link #refund(APIContext, Refund)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param refund
	 * Refund
	 * @return Refund
	 * @throws PayPalRESTException
	 */
	public Refund refund(String accessToken, Refund refund) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return refund(apiContext, refund);
	}

	/**
	 * Creates (and processes) a new Refund Transaction added as a related resource.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param refund
	 * Refund
	 * @return Refund
	 * @throws PayPalRESTException
	 */
	public Refund refund(APIContext apiContext, Refund refund) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (refund == null) {
			throw new IllegalArgumentException("refund cannot be null");
		}
		apiContext.setRequestId(null);
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/payments/capture/{0}/refund";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = refund.toJSON();
		Refund refundResponse = configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Refund.class);
		apiContext.setRequestId(null);
		return refundResponse;
	}

	/**
	 * ID of the capture transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Amount being captured. If the amount matches the orginally authorized amount, the state of the authorization changes to `captured`. If not, the state of the authorization changes to `partially_captured`.
	 */
	@java.lang.SuppressWarnings("all")
	public Amount getAmount() {
		return this.amount;
	}

	/**
	 * If set to `true`, all remaining funds held by the authorization will be released in the funding instrument.
	 */
	@java.lang.SuppressWarnings("all")
	public Boolean getIsFinalCapture() {
		return this.isFinalCapture;
	}

	/**
	 * State of the capture.
	 */
	@java.lang.SuppressWarnings("all")
	public String getState() {
		return this.state;
	}

	/**
	 * ID of the payment resource on which this transaction is based.
	 */
	@java.lang.SuppressWarnings("all")
	public String getParentPayment() {
		return this.parentPayment;
	}

	/**
	 * Transaction fee applicable for this payment.
	 */
	@java.lang.SuppressWarnings("all")
	public Currency getTransactionFee() {
		return this.transactionFee;
	}

	/**
	 * Time of capture as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	@java.lang.SuppressWarnings("all")
	public String getCreateTime() {
		return this.createTime;
	}

	/**
	 * Time that the resource was last updated.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUpdateTime() {
		return this.updateTime;
	}

	/**
	 */
	@java.lang.SuppressWarnings("all")
	public List<Links> getLinks() {
		return this.links;
	}

	/**
	 * ID of the capture transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Amount being captured. If the amount matches the orginally authorized amount, the state of the authorization changes to `captured`. If not, the state of the authorization changes to `partially_captured`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setAmount(final Amount amount) {
		this.amount = amount;
		return this;
	}

	/**
	 * If set to `true`, all remaining funds held by the authorization will be released in the funding instrument.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setIsFinalCapture(final Boolean isFinalCapture) {
		this.isFinalCapture = isFinalCapture;
		return this;
	}

	/**
	 * State of the capture.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setState(final String state) {
		this.state = state;
		return this;
	}

	/**
	 * ID of the payment resource on which this transaction is based.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setParentPayment(final String parentPayment) {
		this.parentPayment = parentPayment;
		return this;
	}

	/**
	 * Transaction fee applicable for this payment.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setTransactionFee(final Currency transactionFee) {
		this.transactionFee = transactionFee;
		return this;
	}

	/**
	 * Time of capture as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setCreateTime(final String createTime) {
		this.createTime = createTime;
		return this;
	}

	/**
	 * Time that the resource was last updated.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setUpdateTime(final String updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	/**
	 *
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Capture setLinks(final List<Links> links) {
		this.links = links;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof Capture)) return false;
		final Capture other = (Capture) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$amount = this.getAmount();
		final java.lang.Object other$amount = other.getAmount();
		if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
		final java.lang.Object this$isFinalCapture = this.getIsFinalCapture();
		final java.lang.Object other$isFinalCapture = other.getIsFinalCapture();
		if (this$isFinalCapture == null ? other$isFinalCapture != null : !this$isFinalCapture.equals(other$isFinalCapture)) return false;
		final java.lang.Object this$state = this.getState();
		final java.lang.Object other$state = other.getState();
		if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
		final java.lang.Object this$parentPayment = this.getParentPayment();
		final java.lang.Object other$parentPayment = other.getParentPayment();
		if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) return false;
		final java.lang.Object this$transactionFee = this.getTransactionFee();
		final java.lang.Object other$transactionFee = other.getTransactionFee();
		if (this$transactionFee == null ? other$transactionFee != null : !this$transactionFee.equals(other$transactionFee)) return false;
		final java.lang.Object this$createTime = this.getCreateTime();
		final java.lang.Object other$createTime = other.getCreateTime();
		if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) return false;
		final java.lang.Object this$updateTime = this.getUpdateTime();
		final java.lang.Object other$updateTime = other.getUpdateTime();
		if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) return false;
		final java.lang.Object this$links = this.getLinks();
		final java.lang.Object other$links = other.getLinks();
		if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof Capture;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $amount = this.getAmount();
		result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
		final java.lang.Object $isFinalCapture = this.getIsFinalCapture();
		result = result * PRIME + ($isFinalCapture == null ? 43 : $isFinalCapture.hashCode());
		final java.lang.Object $state = this.getState();
		result = result * PRIME + ($state == null ? 43 : $state.hashCode());
		final java.lang.Object $parentPayment = this.getParentPayment();
		result = result * PRIME + ($parentPayment == null ? 43 : $parentPayment.hashCode());
		final java.lang.Object $transactionFee = this.getTransactionFee();
		result = result * PRIME + ($transactionFee == null ? 43 : $transactionFee.hashCode());
		final java.lang.Object $createTime = this.getCreateTime();
		result = result * PRIME + ($createTime == null ? 43 : $createTime.hashCode());
		final java.lang.Object $updateTime = this.getUpdateTime();
		result = result * PRIME + ($updateTime == null ? 43 : $updateTime.hashCode());
		final java.lang.Object $links = this.getLinks();
		result = result * PRIME + ($links == null ? 43 : $links.hashCode());
		return result;
	}
}
