// Generated by delombok at Thu Nov 16 13:48:05 CST 2017
package com.paypal.api.payments;

import com.paypal.base.rest.*;

public class EventType extends PayPalResource {
	/**
	 * Unique event-type name.
	 */
	private String name;
	/**
	 * Human readable description of the event-type
	 */
	private String description;

	/**
	 * Default Constructor
	 */
	public EventType() {
	}

	/**
	 * Parameterized Constructor
	 */
	public EventType(String name) {
		this.name = name;
	}

	/**
	 * Retrieves the list of events-types subscribed by the given Webhook.
	 * @deprecated Please use {@link #subscribedEventTypes(APIContext, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param webhookId
	 * String
	 * @return EventTypeList
	 * @throws PayPalRESTException
	 */
	public static EventTypeList subscribedEventTypes(String accessToken, String webhookId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return subscribedEventTypes(apiContext, webhookId);
	}

	/**
	 * Retrieves the list of events-types subscribed by the given Webhook.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param webhookId
	 * String
	 * @return EventTypeList
	 * @throws PayPalRESTException
	 */
	public static EventTypeList subscribedEventTypes(APIContext apiContext, String webhookId) throws PayPalRESTException {
		if (webhookId == null) {
			throw new IllegalArgumentException("webhookId cannot be null");
		}
		Object[] parameters = new Object[] {webhookId};
		String pattern = "v1/notifications/webhooks/{0}/event-types";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		EventTypeList eventTypeList = configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, EventTypeList.class);
		if (eventTypeList == null) {
			eventTypeList = new EventTypeList();
		}
		return eventTypeList;
	}

	/**
	 * Retrieves the master list of available Webhooks events-types resources for any webhook to subscribe to.
	 * @deprecated Please use {@link #availableEventTypes(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return EventTypeList
	 * @throws PayPalRESTException
	 */
	public static EventTypeList availableEventTypes(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return availableEventTypes(apiContext);
	}

	/**
	 * Retrieves the master list of available Webhooks events-types resources for any webhook to subscribe to.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @return EventTypeList
	 * @throws PayPalRESTException
	 */
	public static EventTypeList availableEventTypes(APIContext apiContext) throws PayPalRESTException {
		String resourcePath = "v1/notifications/webhooks-event-types";
		String payLoad = "";
		EventTypeList eventTypeList = configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, EventTypeList.class);
		return eventTypeList;
	}

	/**
	 * Unique event-type name.
	 */
	@java.lang.SuppressWarnings("all")
	public String getName() {
		return this.name;
	}

	/**
	 * Human readable description of the event-type
	 */
	@java.lang.SuppressWarnings("all")
	public String getDescription() {
		return this.description;
	}

	/**
	 * Unique event-type name.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public EventType setName(final String name) {
		this.name = name;
		return this;
	}

	/**
	 * Human readable description of the event-type
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public EventType setDescription(final String description) {
		this.description = description;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof EventType)) return false;
		final EventType other = (EventType) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$name = this.getName();
		final java.lang.Object other$name = other.getName();
		if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
		final java.lang.Object this$description = this.getDescription();
		final java.lang.Object other$description = other.getDescription();
		if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof EventType;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $name = this.getName();
		result = result * PRIME + ($name == null ? 43 : $name.hashCode());
		final java.lang.Object $description = this.getDescription();
		result = result * PRIME + ($description == null ? 43 : $description.hashCode());
		return result;
	}
}
