/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.ConfigManager;
import com.paypal.base.HttpConfiguration;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.exception.HttpErrorException;
import com.paypal.base.exception.InvalidResponseDataException;
import com.paypal.base.exception.SSLConfigurationException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(HttpConnection.class);
    protected HttpConfiguration config;
    protected HttpURLConnection connection;

    public Map<String, List<String>> getResponseHeaderMap() {
        return this.connection.getHeaderFields();
    }

    public String execute(String url, String payload, Map<String, String> headers) throws InvalidResponseDataException, IOException, InterruptedException, HttpErrorException {
        InputStream result = this.executeWithStream(url, payload, headers);
        BufferedReader reader = new BufferedReader(new InputStreamReader(result, "UTF-8"));
        String successResponse = this.read(reader);
        return successResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream executeWithStream(String url, String payload, Map<String, String> headers) throws InvalidResponseDataException, IOException, InterruptedException, HttpErrorException {
        InputStream successResponse = null;
        String errorResponse = null;
        int responseCode = -1;
        BufferedReader reader = null;
        OutputStreamWriter writer = null;
        this.connection.setRequestProperty("Content-Length", String.valueOf(payload.trim().length()));
        try {
            this.setHttpHeaders(headers);
            String mode = ConfigManager.getInstance().getConfigurationMap().get("mode");
            if (!"live".equalsIgnoreCase(mode)) {
                this.logCurlRequest(payload, headers);
            }
            Exception lastException = null;
            int retry = 0;
            do {
                try {
                    if (Arrays.asList("POST", "PUT", "PATCH").contains(this.connection.getRequestMethod().toUpperCase())) {
                        writer = new OutputStreamWriter(this.connection.getOutputStream(), Charset.forName("UTF-8"));
                        writer.write(payload);
                        writer.flush();
                    }
                    if ((responseCode = this.connection.getResponseCode()) >= 200 && responseCode < 300) {
                        try {
                            successResponse = this.connection.getInputStream();
                        }
                        catch (IOException e) {
                            successResponse = this.connection.getErrorStream();
                        }
                        break;
                    }
                    reader = new BufferedReader(new InputStreamReader(this.connection.getInputStream(), "UTF-8"));
                    errorResponse = this.read(reader);
                    String msg = "Response code: " + responseCode + "\tError response: " + errorResponse;
                    if (responseCode >= 300 && responseCode < 500) {
                        throw new ClientActionRequiredException(responseCode, errorResponse, msg, new IOException(msg));
                    }
                    if (responseCode >= 500) {
                        throw new HttpErrorException(responseCode, errorResponse, msg, new IOException(msg));
                    }
                }
                catch (IOException e) {
                    lastException = e;
                    try {
                        responseCode = this.connection.getResponseCode();
                        if (this.connection.getErrorStream() != null) {
                            reader = new BufferedReader(new InputStreamReader(this.connection.getErrorStream(), "UTF-8"));
                            errorResponse = this.read(reader);
                            log.error("Response code: " + responseCode + "\tError response: " + errorResponse);
                        }
                        if (errorResponse == null || errorResponse.length() == 0) {
                            errorResponse = e.getMessage();
                        }
                        if (responseCode <= 500) {
                            String msg = "Response code: " + responseCode + "\tError response: " + errorResponse;
                            throw new HttpErrorException(responseCode, errorResponse, msg, e);
                        }
                    }
                    catch (HttpErrorException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        lastException = ex;
                        log.error("Caught exception while handling error response", (Throwable)ex);
                    }
                }
                if (++retry <= 0) continue;
                log.error(" Retry  No : " + retry + "...");
                Thread.sleep(this.config.getRetryDelay());
            } while (retry < this.config.getMaxRetry());
            if (successResponse == null || successResponse.available() <= 0 && (responseCode < 200 || responseCode >= 300)) {
                throw new HttpErrorException("retry fails..  check log for more information", lastException);
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            finally {
                reader = null;
                writer = null;
            }
        }
        return successResponse;
    }

    private void logCurlRequest(String payload, Map<String, String> headers) {
        StringBuilder cmdBuilder = new StringBuilder("curl command: \n");
        cmdBuilder.append("curl --verbose");
        cmdBuilder.append(" --request ").append(this.connection.getRequestMethod().toUpperCase());
        cmdBuilder.append(" '").append(this.connection.getURL().toString()).append("'");
        if (headers != null) {
            for (String key : headers.keySet()) {
                String value = headers.get(key);
                cmdBuilder.append(String.format(" \\\n  --header \"%s:%s\"", key, value));
            }
        }
        cmdBuilder.append(String.format(" \\\n  --data '%s'", payload));
        log.debug(cmdBuilder.toString());
    }

    public abstract void setupClientSSL(String var1, String var2) throws SSLConfigurationException;

    public abstract void createAndconfigureHttpConnection(HttpConfiguration var1) throws IOException;

    protected String read(BufferedReader reader) throws IOException {
        String inputLine;
        StringBuilder response = new StringBuilder();
        while ((inputLine = reader.readLine()) != null) {
            response.append(inputLine);
        }
        return response.toString();
    }

    protected void setHttpHeaders(Map<String, String> headers) {
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> pairs : headers.entrySet()) {
                String key = pairs.getKey();
                String value = pairs.getValue();
                this.connection.setRequestProperty(key, value);
            }
        }
    }
}

