/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.paypal.api.payments.Error;
import com.paypal.base.exception.HttpErrorException;
import com.paypal.base.rest.JSONFormatter;

public class PayPalRESTException
extends Exception {
    private static final long serialVersionUID = 1L;
    private int responsecode;
    private Error details;

    public PayPalRESTException(String message) {
        super(message);
    }

    public PayPalRESTException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public PayPalRESTException(Throwable throwable) {
        super(throwable);
    }

    public int getResponsecode() {
        return this.responsecode;
    }

    public void setResponsecode(int responsecode) {
        this.responsecode = responsecode;
    }

    public Error getDetails() {
        return this.details;
    }

    public void setDetails(Error details) {
        this.details = details;
    }

    protected static PayPalRESTException createFromHttpErrorException(HttpErrorException httpErrorException) {
        PayPalRESTException ppre = new PayPalRESTException(httpErrorException.getMessage(), httpErrorException);
        ppre.setResponsecode(httpErrorException.getResponsecode());
        if (400 == httpErrorException.getResponsecode() && httpErrorException.getErrorResponse() != null) {
            try {
                Error details = JSONFormatter.fromJSON(httpErrorException.getErrorResponse(), Error.class);
                ppre.setDetails(details);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ppre;
    }
}

