/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.openidconnect;

import com.paypal.base.ClientCredentials;
import com.paypal.base.ConfigManager;
import com.paypal.base.SDKUtil;
import com.paypal.base.rest.APIContext;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Session {
    private Session() {
    }

    public static String getRedirectURL(String redirectURI, List<String> scope, APIContext apiContext) {
        return Session.getRedirectURL(redirectURI, scope, apiContext, null);
    }

    public static String getRedirectURL(String redirectURI, List<String> scope, APIContext apiContext, ClientCredentials clientCredentials) {
        String redirectURL = null;
        Map<String, String> configurationMap = null;
        try {
            configurationMap = apiContext.getConfigurationMap() == null ? SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap()) : SDKUtil.combineDefaultMap(apiContext.getConfigurationMap());
            String baseURL = configurationMap.get("openid.RedirectUri");
            if (baseURL == null || baseURL.trim().length() <= 0) {
                if (configurationMap.get("mode") == null || !"live".equalsIgnoreCase(configurationMap.get("mode")) && !"sandbox".equalsIgnoreCase(configurationMap.get("mode"))) {
                    throw new RuntimeException("Mode parameter not set in dynamic configuration map");
                }
                if ("live".equalsIgnoreCase(configurationMap.get("mode"))) {
                    baseURL = "https://www.paypal.com/webapps/auth/protocol/openidconnect";
                } else if ("sandbox".equalsIgnoreCase(configurationMap.get("mode"))) {
                    baseURL = "https://www.sandbox.paypal.com/webapps/auth/protocol/openidconnect";
                }
            }
            if (scope == null || scope.size() <= 0) {
                scope = new ArrayList<String>();
                scope.add("openid");
                scope.add("profile");
                scope.add("address");
                scope.add("email");
                scope.add("phone");
                scope.add("https://uri.paypal.com/services/paypalattributes");
                scope.add("https://uri.paypal.com/services/expresscheckout");
            }
            if (!scope.contains("openid")) {
                scope.add("openid");
            }
            StringBuilder stringBuilder = new StringBuilder();
            String clientID = null;
            clientID = clientCredentials == null ? (configurationMap.get("clientId") != null ? configurationMap.get("clientId") : "") : (clientCredentials.getClientID() != null ? clientCredentials.getClientID() : "");
            stringBuilder.append("client_id=").append(URLEncoder.encode(clientID, "UTF-8")).append("&response_type=").append("code").append("&scope=");
            StringBuilder scpBuilder = new StringBuilder();
            for (String str : scope) {
                scpBuilder.append(str).append(" ");
            }
            stringBuilder.append(URLEncoder.encode(scpBuilder.toString(), "UTF-8"));
            stringBuilder.append("&redirect_uri=").append(URLEncoder.encode(redirectURI, "UTF-8"));
            redirectURL = baseURL + "/v1/authorize?" + stringBuilder.toString();
        }
        catch (UnsupportedEncodingException exe) {
            // empty catch block
        }
        return redirectURL;
    }

    public static String getLogoutUrl(String redirectURI, String idToken, APIContext apiContext) {
        String logoutURL = null;
        Map<String, String> configurationMap = null;
        try {
            configurationMap = apiContext.getConfigurationMap() == null ? SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap()) : SDKUtil.combineDefaultMap(apiContext.getConfigurationMap());
            String baseURL = configurationMap.get("openid.RedirectUri");
            if (baseURL == null || baseURL.trim().length() <= 0) {
                if (configurationMap.get("mode") == null || !"live".equalsIgnoreCase(configurationMap.get("mode")) && !"sandbox".equalsIgnoreCase(configurationMap.get("mode"))) {
                    throw new RuntimeException("Mode parameter not set in dynamic configuration map");
                }
                if ("live".equalsIgnoreCase(configurationMap.get("mode"))) {
                    baseURL = "https://www.paypal.com/webapps/auth/protocol/openidconnect";
                } else if ("sandbox".equalsIgnoreCase(configurationMap.get("mode"))) {
                    baseURL = "https://www.sandbox.paypal.com/webapps/auth/protocol/openidconnect";
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("id_token=").append(URLEncoder.encode(idToken, "UTF-8")).append("&redirect_uri=").append(URLEncoder.encode(redirectURI, "UTF-8")).append("&logout=true");
            logoutURL = baseURL + "/v1/endsession?" + stringBuilder.toString();
        }
        catch (UnsupportedEncodingException exe) {
            // empty catch block
        }
        return logoutURL;
    }
}

