/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.EventList;
import com.paypal.api.payments.Links;
import com.paypal.base.SDKUtil;
import com.paypal.base.SSLUtil;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
extends PayPalResource {
    private static final Logger log = LoggerFactory.getLogger(Event.class);
    private String id;
    private String createTime;
    private String resourceType;
    private String eventType;
    private String summary;
    private Object resource;
    private List<Links> links;

    public Event setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Event setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Event setResourceType(String resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public Event setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public String getEventType() {
        return this.eventType;
    }

    public Event setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Event setResource(Object resource) {
        this.resource = resource;
        return this;
    }

    public Object getResource() {
        return this.resource;
    }

    public Event setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public static Event get(String accessToken, String eventId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Event.get(apiContext, eventId);
    }

    public static Event get(APIContext apiContext, String eventId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (eventId == null) {
            throw new IllegalArgumentException("eventId cannot be null");
        }
        Object[] parameters = new Object[]{eventId};
        String pattern = "v1/notifications/webhooks-events/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Event.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Event.class);
    }

    public Event resend(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.resend(apiContext);
    }

    public Event resend(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/notifications/webhooks-events/{0}/resend";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Event.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Event.class);
    }

    public static EventList list(String accessToken, String queryParams) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Event.list(apiContext, queryParams);
    }

    public static EventList list(APIContext apiContext, String queryParams) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        String resourcePath = "v1/notifications/webhooks-events" + queryParams;
        String payLoad = "";
        return Event.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, EventList.class);
    }

    public static boolean validateReceivedEvent(APIContext apiContext, Map<String, String> headers, String requestBody) throws PayPalRESTException, InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        if (headers == null) {
            throw new PayPalRESTException("Headers cannot be null");
        }
        HashMap<String, String> cmap = new HashMap();
        Boolean isChainValid = false;
        Boolean isDataValid = false;
        cmap = Event.getConfigurations(apiContext);
        String clientCertificateLocation = SDKUtil.validateAndGet(headers, "Paypal-Cert-Url");
        String trustCertificateLocation = SDKUtil.validateAndGet(cmap, "webhook.trustCert");
        Collection<X509Certificate> clientCerts = SSLUtil.getCertificateFromStream(SSLUtil.downloadCertificateFromPath(clientCertificateLocation));
        Collection<X509Certificate> trustCerts = SSLUtil.getCertificateFromStream(Event.class.getClassLoader().getResourceAsStream(trustCertificateLocation));
        isChainValid = SSLUtil.validateCertificateChain(clientCerts, trustCerts, SDKUtil.validateAndGet(cmap, "webhook.authType"));
        log.debug("Is Chain Valid: " + isChainValid);
        if (isChainValid.booleanValue()) {
            String webhookId = SDKUtil.validateAndGet(cmap, "webhook.id");
            String actualSignatureEncoded = SDKUtil.validateAndGet(headers, "Paypal-Transmission-Sig");
            String authAlgo = SDKUtil.validateAndGet(headers, "Paypal-Auth-Algo");
            String transmissionId = SDKUtil.validateAndGet(headers, "Paypal-Transmission-Id");
            String transmissionTime = SDKUtil.validateAndGet(headers, "Paypal-Transmission-Time");
            String expectedSignature = String.format("%s|%s|%s|%s", transmissionId, transmissionTime, webhookId, SSLUtil.crc32(requestBody));
            isDataValid = SSLUtil.validateData(clientCerts, authAlgo, actualSignatureEncoded, expectedSignature, requestBody, webhookId);
            log.debug("Is Data Valid: " + isDataValid);
            return isDataValid;
        }
        return false;
    }

    private static Map<String, String> getConfigurations(APIContext apiContext) {
        Map<Object, Object> cmap = new HashMap();
        if (apiContext != null) {
            if (apiContext.getConfigurationMap() == null) {
                apiContext.setConfigurationMap(new HashMap<String, String>());
            }
            cmap = SDKUtil.combineDefaultMap(apiContext.getConfigurationMap());
            cmap = SDKUtil.combineMap(cmap, PayPalResource.getConfigurations());
        } else {
            cmap = SDKUtil.combineDefaultMap(PayPalResource.getConfigurations());
        }
        return cmap;
    }
}

