/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.openidconnect;

import com.paypal.api.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.api.openidconnect.CreateFromRefreshTokenParameters;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.OAuthTokenCredential;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;

public class Tokeninfo
extends PayPalResource {
    private String scope;
    private String accessToken;
    private String refreshToken;
    private String tokenType;
    private Integer expiresIn;
    private String appId;

    public Tokeninfo() {
    }

    public Tokeninfo(String accessToken, String tokenType, Integer expiresIn) {
        this.accessToken = accessToken;
        this.tokenType = tokenType;
        this.expiresIn = expiresIn;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAccessTokenWithType() {
        return this.tokenType + " " + this.accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public static Tokeninfo createFromAuthorizationCode(CreateFromAuthorizationCodeParameters createFromAuthorizationCodeParameters) throws PayPalRESTException {
        return Tokeninfo.createFromAuthorizationCode(null, createFromAuthorizationCodeParameters);
    }

    public static Tokeninfo createFromAuthorizationCode(APIContext apiContext, CreateFromAuthorizationCodeParameters createFromAuthorizationCodeParameters) throws PayPalRESTException {
        String pattern = "v1/identity/openidconnect/tokenservice?grant_type={0}&code={1}&redirect_uri={2}";
        Object[] parameters = new Object[]{createFromAuthorizationCodeParameters};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        return Tokeninfo.createFromAuthorizationCodeParameters(apiContext, createFromAuthorizationCodeParameters, resourcePath);
    }

    public static Tokeninfo createFromAuthorizationCodeForFpp(APIContext apiContext, CreateFromAuthorizationCodeParameters createFromAuthorizationCodeParameters) throws PayPalRESTException {
        String pattern = "v1/oauth2/token?grant_type=authorization_code&response_type=token&redirect_uri=urn:ietf:wg:oauth:2.0:oob&code={0}";
        Object[] parameters = new Object[]{createFromAuthorizationCodeParameters.getContainerMap().get("code")};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        return Tokeninfo.createFromAuthorizationCodeParameters(apiContext, createFromAuthorizationCodeParameters, resourcePath);
    }

    private static Tokeninfo createFromAuthorizationCodeParameters(APIContext apiContext, CreateFromAuthorizationCodeParameters createFromAuthorizationCodeParameters, String resourcePath) throws PayPalRESTException {
        String payLoad = resourcePath.substring(resourcePath.indexOf(63) + 1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(63));
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (apiContext == null) {
            apiContext = new APIContext();
        }
        apiContext.setMaskRequestId(true);
        if (createFromAuthorizationCodeParameters.getClientID() == null || createFromAuthorizationCodeParameters.getClientID().trim().length() <= 0 || createFromAuthorizationCodeParameters.getClientSecret() == null || createFromAuthorizationCodeParameters.getClientSecret().trim().length() <= 0) {
            throw new PayPalRESTException("ClientID and ClientSecret not set in CreateFromAuthorizationCodeParameters");
        }
        OAuthTokenCredential oauthTokenCredential = new OAuthTokenCredential(createFromAuthorizationCodeParameters.getClientID(), createFromAuthorizationCodeParameters.getClientSecret(), apiContext.getConfigurationMap());
        String authorizationHeader = oauthTokenCredential.getAuthorizationHeader();
        headersMap.put("Authorization", authorizationHeader);
        headersMap.put("Content-Type", "application/x-www-form-urlencoded");
        headersMap.put("Accept", "application/json");
        apiContext.setHTTPHeaders(headersMap);
        return Tokeninfo.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Tokeninfo.class);
    }

    public Tokeninfo createFromRefreshToken(CreateFromRefreshTokenParameters createFromRefreshTokenParameters) throws PayPalRESTException {
        return this.createFromRefreshToken(null, createFromRefreshTokenParameters);
    }

    public Tokeninfo createFromRefreshToken(APIContext apiContext, CreateFromRefreshTokenParameters createFromRefreshTokenParameters) throws PayPalRESTException {
        String pattern = "v1/identity/openidconnect/tokenservice?grant_type={0}&refresh_token={1}&scope={2}&client_id={3}&client_secret={4}";
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.putAll(createFromRefreshTokenParameters.getContainerMap());
        try {
            paramsMap.put("refresh_token", URLEncoder.encode(this.getRefreshToken(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        Object[] parameters = new Object[]{paramsMap};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = resourcePath.substring(resourcePath.indexOf(63) + 1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(63));
        if (apiContext == null) {
            apiContext = new APIContext();
        }
        apiContext.setMaskRequestId(true);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (createFromRefreshTokenParameters.getClientID() == null || createFromRefreshTokenParameters.getClientID().trim().length() <= 0 || createFromRefreshTokenParameters.getClientSecret() == null || createFromRefreshTokenParameters.getClientSecret().trim().length() <= 0) {
            throw new PayPalRESTException("ClientID and ClientSecret not set in CreateFromRefreshTokenParameters");
        }
        OAuthTokenCredential oauthTokenCredential = new OAuthTokenCredential(createFromRefreshTokenParameters.getClientID(), createFromRefreshTokenParameters.getClientSecret(), apiContext.getConfigurationMap());
        String authorizationHeader = oauthTokenCredential.getAuthorizationHeader();
        headersMap.put("Authorization", authorizationHeader);
        headersMap.put("Content-Type", "application/x-www-form-urlencoded");
        apiContext.setHTTPHeaders(headersMap);
        return Tokeninfo.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Tokeninfo.class);
    }

    public Tokeninfo createFromRefreshTokenForFpp(APIContext apiContext) throws PayPalRESTException {
        if (this.getRefreshToken() == null || this.getRefreshToken().equals("")) {
            throw new PayPalRESTException("refresh token is empty");
        }
        String pattern = "v1/oauth2/token?grant_type=refresh_token&refresh_token={0}";
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        try {
            paramsMap.put("refresh_token", URLEncoder.encode(this.getRefreshToken(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            // empty catch block
        }
        Object[] parameters = new Object[]{paramsMap};
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = resourcePath.substring(resourcePath.indexOf(63) + 1);
        resourcePath = resourcePath.substring(0, resourcePath.indexOf(63));
        if (apiContext == null) {
            apiContext = new APIContext();
        }
        apiContext.setMaskRequestId(true);
        HashMap<String, String> headersMap = new HashMap<String, String>();
        headersMap.put("Content-Type", "application/x-www-form-urlencoded");
        apiContext.setHTTPHeaders(headersMap);
        return Tokeninfo.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Tokeninfo.class);
    }
}

