/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.APICallPreHandler;
import com.paypal.base.APIService;
import com.paypal.base.ConfigManager;
import com.paypal.base.SDKUtil;
import com.paypal.base.exception.ClientActionRequiredException;
import com.paypal.base.exception.HttpErrorException;
import com.paypal.base.exception.InvalidCredentialException;
import com.paypal.base.exception.InvalidResponseDataException;
import com.paypal.base.exception.MissingCredentialException;
import com.paypal.base.exception.OAuthException;
import com.paypal.base.exception.SSLConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseService {
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    protected Map<String, String> configurationMap = null;
    private String accessToken = null;
    private String tokenSecret = null;
    private String lastRequest = null;
    private String lastResponse = null;

    public BaseService() {
    }

    public BaseService(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        this.configurationMap = SDKUtil.constructMap(properties);
    }

    public BaseService(Properties properties) {
        this.configurationMap = SDKUtil.constructMap(properties);
    }

    public BaseService(Map<String, String> configurationMap) {
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public String getLastRequest() {
        return this.lastRequest;
    }

    public void setLastRequest(String lastRequest) {
        this.lastRequest = lastRequest;
    }

    public String getLastResponse() {
        return this.lastResponse;
    }

    public void setLastResponse(String lastResponse) {
        this.lastResponse = lastResponse;
    }

    protected void initializeToDefault() {
        this.configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
    }

    protected static void initConfig(InputStream is) throws IOException {
        try {
            ConfigManager.getInstance().load(is);
        }
        catch (IOException ioe) {
            log.debug(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
    }

    protected static void initConfig(File file) throws IOException {
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("File doesn't exist: " + file.getAbsolutePath());
            }
            FileInputStream fis = new FileInputStream(file);
            BaseService.initConfig(fis);
        }
        catch (IOException ioe) {
            log.debug(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
    }

    protected static void initConfig(String filepath) throws IOException {
        try {
            File file = new File(filepath);
            BaseService.initConfig(file);
        }
        catch (IOException ioe) {
            log.debug(ioe.getMessage(), (Throwable)ioe);
            throw ioe;
        }
    }

    protected static void initConfig(Properties properties) {
        ConfigManager.getInstance().load(properties);
    }

    protected String call(APICallPreHandler apiCallPrehandler) throws InvalidResponseDataException, HttpErrorException, ClientActionRequiredException, InvalidCredentialException, MissingCredentialException, OAuthException, SSLConfigurationException, IOException, InterruptedException {
        String response;
        if (this.configurationMap == null || this.configurationMap.size() <= 0) {
            throw new ClientActionRequiredException("Configuration not loaded..");
        }
        APIService apiService = new APIService(this.configurationMap);
        this.lastRequest = apiCallPrehandler.getPayLoad();
        this.lastResponse = response = apiService.makeRequestUsing(apiCallPrehandler);
        return response;
    }
}

