/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Amount;
import com.paypal.api.payments.Capture;
import com.paypal.api.payments.FmfDetails;
import com.paypal.api.payments.Links;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import com.paypal.base.sdk.info.SDKVersionImpl;
import java.util.HashMap;
import java.util.List;

public class Authorization
extends PayPalResource {
    private String id;
    private String createTime;
    private String updateTime;
    private Amount amount;
    private String paymentMode;
    private String state;
    private String protectionEligibility;
    private String protectionEligibilityType;
    private String parentPayment;
    private String validUntil;
    private List<Links> links;
    private String pendingReason;
    private String reasonCode;
    private FmfDetails fmfDetails;

    public Authorization setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Authorization setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public Authorization setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public Authorization setAmount(Amount amount) {
        this.amount = amount;
        return this;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Authorization setPaymentMode(String paymentMode) {
        this.paymentMode = paymentMode;
        return this;
    }

    public String getPaymentMode() {
        return this.paymentMode;
    }

    public Authorization setState(String state) {
        this.state = state;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public Authorization setProtectionEligibility(String protectionEligibility) {
        this.protectionEligibility = protectionEligibility;
        return this;
    }

    public String getProtectionEligibility() {
        return this.protectionEligibility;
    }

    public Authorization setProtectionEligibilityType(String protectionEligibilityType) {
        this.protectionEligibilityType = protectionEligibilityType;
        return this;
    }

    public String getProtectionEligibilityType() {
        return this.protectionEligibilityType;
    }

    public Authorization setParentPayment(String parentPayment) {
        this.parentPayment = parentPayment;
        return this;
    }

    public String getParentPayment() {
        return this.parentPayment;
    }

    public Authorization setValidUntil(String validUntil) {
        this.validUntil = validUntil;
        return this;
    }

    public String getValidUntil() {
        return this.validUntil;
    }

    public Authorization setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public String getPendingReason() {
        return this.pendingReason;
    }

    public Authorization setPendingReason(String pendingReason) {
        this.pendingReason = pendingReason;
        return this;
    }

    public String getReasonCode() {
        return this.reasonCode;
    }

    public Authorization setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public FmfDetails getFmfDetails() {
        return this.fmfDetails;
    }

    public Authorization setFmfDetails(FmfDetails fmfDetails) {
        this.fmfDetails = fmfDetails;
        return this;
    }

    public static Authorization get(String accessToken, String authorizationId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Authorization.get(apiContext, authorizationId);
    }

    public static Authorization get(APIContext apiContext, String authorizationId) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (authorizationId == null) {
            throw new IllegalArgumentException("authorizationId cannot be null");
        }
        Object[] parameters = new Object[]{authorizationId};
        String pattern = "v1/payments/authorization/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Authorization.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Authorization.class);
    }

    public Capture capture(String accessToken, Capture capture) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.capture(apiContext, capture);
    }

    public Capture capture(APIContext apiContext, Capture capture) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (capture == null) {
            throw new IllegalArgumentException("capture cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/capture";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = capture.toJSON();
        return Authorization.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Capture.class);
    }

    public Authorization doVoid(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.doVoid(apiContext);
    }

    public Authorization doVoid(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/void";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Authorization.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Authorization.class);
    }

    public Authorization reauthorize(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.reauthorize(apiContext);
    }

    public Authorization reauthorize(APIContext apiContext) throws PayPalRESTException {
        if (apiContext == null) {
            throw new IllegalArgumentException("APIContext cannot be null");
        }
        if (apiContext.getAccessToken() == null || apiContext.getAccessToken().trim().length() <= 0) {
            throw new IllegalArgumentException("AccessToken cannot be null or empty");
        }
        if (apiContext.getHTTPHeaders() == null) {
            apiContext.setHTTPHeaders(new HashMap<String, String>());
        }
        apiContext.getHTTPHeaders().put("Content-Type", "application/json");
        apiContext.setSdkVersion(new SDKVersionImpl());
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/authorization/{0}/reauthorize";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = this.toJSON();
        return Authorization.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Authorization.class);
    }
}

