/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.ConfigManager;
import com.paypal.base.ConnectionManager;
import com.paypal.base.HttpConfiguration;
import com.paypal.base.HttpConnection;
import com.paypal.base.SDKUtil;
import com.paypal.base.codec.binary.Base64;
import com.paypal.base.exception.SSLConfigurationException;
import com.paypal.base.rest.PayPalRESTException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLUtil {
    private static final Logger log = LoggerFactory.getLogger(SSLUtil.class);
    private static final KeyManagerFactory KMF;
    private static final Map<String, KeyStore> STOREMAP;
    private static final Map<String, String> CONFIG_MAP;

    public static SSLContext getSSLContext(KeyManager[] keymanagers) throws SSLConfigurationException {
        try {
            SSLContext ctx = null;
            String protocol = CONFIG_MAP.get("sslutil.protocol");
            try {
                ctx = SSLContext.getInstance("TLSv1.2");
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("SECURITY WARNING: TLSv1.2 is not supported on this system. Please update your Java runtime to a version that supports TLSv1.2.");
                ctx = SSLContext.getInstance(protocol);
            }
            ctx.init(keymanagers, null, null);
            return ctx;
        }
        catch (Exception e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore p12ToKeyStore(String p12Path, String password) throws NoSuchProviderException, KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = STOREMAP.get(p12Path);
        if (keyStore == null) {
            keyStore = KeyStore.getInstance("PKCS12", CONFIG_MAP.get("sslutil.jre"));
            try (FileInputStream in = null;){
                in = new FileInputStream(p12Path);
                keyStore.load(in, password.toCharArray());
                STOREMAP.put(p12Path, keyStore);
            }
        }
        return keyStore;
    }

    public static SSLContext setupClientSSL(String certPath, String certPassword) throws SSLConfigurationException {
        SSLContext sslContext = null;
        try {
            KeyStore ks = SSLUtil.p12ToKeyStore(certPath, certPassword);
            KMF.init(ks, certPassword.toCharArray());
            sslContext = SSLUtil.getSSLContext(KMF.getKeyManagers());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new SSLConfigurationException(e.getMessage(), e);
        }
        return sslContext;
    }

    public static boolean validateCertificateChain(Collection<X509Certificate> clientCerts, Collection<X509Certificate> trustCerts, String authType) throws PayPalRESTException {
        TrustManager[] trustManagers;
        X509Certificate[] clientChain;
        try {
            clientChain = clientCerts.toArray(new X509Certificate[0]);
            List<X509Certificate> list = Arrays.asList(clientChain);
            clientChain = list.toArray(new X509Certificate[0]);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, "".toCharArray());
            int i = 0;
            for (X509Certificate x509Certificate : trustCerts) {
                keyStore.setCertificateEntry("paypalCert" + i, x509Certificate);
                ++i;
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        catch (Exception ex) {
            throw new PayPalRESTException(ex);
        }
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager pkixTrustManager = (X509TrustManager)trustManager;
            try {
                pkixTrustManager.checkClientTrusted(clientChain, authType == null || authType == "" ? "RSA" : authType);
                for (X509Certificate cert : clientChain) {
                    cert.checkValidity();
                    String dn = cert.getSubjectX500Principal().getName();
                    if (dn.contains("CN=messageverificationcerts")) continue;
                    throw new PayPalRESTException("CN of client certificate does not match with trusted CN");
                }
                return true;
            }
            catch (CertificateException e) {
                throw new PayPalRESTException(e);
            }
        }
        return false;
    }

    public static InputStream downloadCertificateFromPath(String urlPath) throws PayPalRESTException {
        if (urlPath == null || urlPath.trim() == "") {
            throw new PayPalRESTException("Certificate Path cannot be empty");
        }
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setEndPointUrl(urlPath);
            httpConfiguration.setConnectionTimeout(Integer.parseInt(ConfigManager.getInstance().getConfigurationMap().get("http.ConnectionTimeOut")));
            httpConfiguration.setMaxRetry(Integer.parseInt(ConfigManager.getInstance().getConfigurationMap().get("http.Retry")));
            httpConfiguration.setReadTimeout(Integer.parseInt(ConfigManager.getInstance().getConfigurationMap().get("http.ReadTimeOut")));
            httpConfiguration.setMaxHttpConnection(Integer.parseInt(ConfigManager.getInstance().getConfigurationMap().get("http.MaxConnection")));
            httpConfiguration.setHttpMethod("GET");
            URL url = null;
            HttpConnection connection = ConnectionManager.getInstance().getConnection();
            connection.createAndconfigureHttpConnection(httpConfiguration);
            url = new URL(urlPath);
            headerMap.put("Host", url.getHost());
            InputStream stream = connection.executeWithStream(url.toString(), "", headerMap);
            return stream;
        }
        catch (Exception ex) {
            throw new PayPalRESTException(ex);
        }
    }

    public static Collection<X509Certificate> getCertificateFromStream(InputStream stream) throws PayPalRESTException {
        if (stream == null) {
            throw new PayPalRESTException("Certificate Not Found");
        }
        Collection<? extends Certificate> certs = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            certs = cf.generateCertificates(stream);
        }
        catch (CertificateException ex) {
            throw new PayPalRESTException(ex);
        }
        return certs;
    }

    public static long crc32(String data) {
        if (data == null) {
            return -1L;
        }
        byte[] bytes = data.getBytes();
        CRC32 checksum = new CRC32();
        checksum.update(bytes, 0, bytes.length);
        return checksum.getValue();
    }

    public static Boolean validateData(Collection<X509Certificate> clientCerts, String algo, String actualSignatureEncoded, String expectedSignature, String requestBody, String webhookId) throws NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        Signature signatureAlgorithm = Signature.getInstance(algo);
        X509Certificate[] clientChain = clientCerts.toArray(new X509Certificate[0]);
        signatureAlgorithm.initVerify(clientChain[0].getPublicKey());
        signatureAlgorithm.update(expectedSignature.getBytes());
        byte[] actualSignature = Base64.decodeBase64(actualSignatureEncoded.getBytes());
        boolean isValid = signatureAlgorithm.verify(actualSignature);
        return isValid;
    }

    static {
        try {
            KMF = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            STOREMAP = new HashMap<String, KeyStore>();
            CONFIG_MAP = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

