/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.HttpConfiguration;
import com.paypal.base.HttpConnection;
import com.paypal.base.exception.SSLConfigurationException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAppEngineHttpConnection
extends HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(GoogleAppEngineHttpConnection.class);

    @Override
    public void setupClientSSL(String certPath, String certKey) throws SSLConfigurationException {
        if (certPath != null || certKey != null) {
            log.warn("The PayPal SDK cannot be used with client SSL on Google App Engine; configure the SDK to use a PayPal API Signature instead");
        }
    }

    @Override
    public void createAndconfigureHttpConnection(HttpConfiguration clientConfiguration) throws IOException {
        this.config = clientConfiguration;
        URL url = new URL(this.config.getEndPointUrl());
        this.connection = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod(this.config.getHttpMethod());
        this.connection.setConnectTimeout(this.config.getConnectionTimeout());
        this.connection.setReadTimeout(this.config.getReadTimeout());
    }
}

