/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.paypal.api.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.api.openidconnect.CreateFromRefreshTokenParameters;
import com.paypal.api.openidconnect.UserinfoParameters;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.QueryParameters;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;

public final class RESTUtil {
    private RESTUtil() {
    }

    public static String formatURIPath(String pattern, Object[] parameters) {
        String formattedPath = null;
        Object[] finalParameters = null;
        if (pattern != null) {
            finalParameters = parameters != null && parameters.length == 1 && parameters[0] instanceof CreateFromAuthorizationCodeParameters ? RESTUtil.splitParameters(pattern, ((CreateFromAuthorizationCodeParameters)parameters[0]).getContainerMap()) : (parameters != null && parameters.length == 1 && parameters[0] instanceof CreateFromRefreshTokenParameters ? RESTUtil.splitParameters(pattern, ((CreateFromRefreshTokenParameters)parameters[0]).getContainerMap()) : (parameters != null && parameters.length == 1 && parameters[0] instanceof UserinfoParameters ? RESTUtil.splitParameters(pattern, ((UserinfoParameters)parameters[0]).getContainerMap()) : (parameters != null && parameters.length == 1 && parameters[0] instanceof QueryParameters ? RESTUtil.splitParameters(pattern, ((QueryParameters)parameters[0]).getContainerMap()) : (parameters != null && parameters.length == 1 && parameters[0] instanceof Map ? RESTUtil.splitParameters(pattern, (Map)parameters[0]) : parameters))));
            String fString = MessageFormat.format(pattern, finalParameters);
            formattedPath = RESTUtil.removeNullsInQS(fString);
        }
        return formattedPath;
    }

    public static String formatURIPath(String pattern, Map<String, String> pathParameters) throws PayPalRESTException {
        return RESTUtil.formatURIPath(pattern, pathParameters, null);
    }

    public static String formatURIPath(String pattern, Map<String, String> pathParameters, Map<String, String> queryParameters) throws PayPalRESTException {
        String formattedURIPath = null;
        if (pattern != null && pattern.trim().length() > 0 && pathParameters != null && pathParameters.size() > 0) {
            for (Map.Entry<String, String> entry : pathParameters.entrySet()) {
                String placeHolderName = "{" + entry.getKey().trim() + "}";
                if (!pattern.contains(placeHolderName)) continue;
                pattern = pattern.replace(placeHolderName, entry.getValue().trim());
            }
        }
        formattedURIPath = pattern;
        if (queryParameters != null && queryParameters.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(formattedURIPath);
            if (stringBuilder.toString().contains("?")) {
                if (!stringBuilder.toString().endsWith("?") && !stringBuilder.toString().endsWith("&")) {
                    stringBuilder.append("&");
                }
            } else {
                stringBuilder.append("?");
            }
            for (Map.Entry<String, String> entry : queryParameters.entrySet()) {
                try {
                    stringBuilder.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
            formattedURIPath = stringBuilder.toString();
        }
        if (formattedURIPath.contains("{") || formattedURIPath.contains("}")) {
            throw new PayPalRESTException("Unable to formatURI Path : " + formattedURIPath + ", unable to replace placeholders with the map : " + pathParameters);
        }
        return formattedURIPath;
    }

    private static String removeNullsInQS(String fString) {
        String[] parts;
        String formattedString = fString;
        if (fString != null && fString.length() != 0 && (parts = fString.split("\\?")).length == 2) {
            String queryString = parts[1];
            String[] querys = queryString.split("&");
            if (querys.length > 0) {
                StringBuilder strBuilder = new StringBuilder();
                for (String query : querys) {
                    String[] valueSplit = query.split("=");
                    if (valueSplit.length == 2) {
                        if ("null".equalsIgnoreCase(valueSplit[1].trim()) || "".equals(valueSplit[1].trim())) continue;
                        strBuilder.append(query).append("&");
                        continue;
                    }
                    if (valueSplit.length >= 2) continue;
                }
                formattedString = !strBuilder.toString().endsWith("&") ? strBuilder.toString() : strBuilder.toString().substring(0, strBuilder.toString().length() - 1);
            }
            formattedString = parts[0].trim() + "?" + formattedString;
        }
        return formattedString;
    }

    private static Object[] splitParameters(String pattern, Map<?, ?> containerMap) {
        String[] queries;
        ArrayList<String> objectList = new ArrayList<String>();
        String[] query = pattern.split("\\?");
        if (query != null && query.length == 2 && query[1].contains("={") && (queries = query[1].split("&")) != null) {
            for (String q : queries) {
                String[] params = q.split("=");
                if (params == null || params.length != 2) continue;
                String key = params[0].trim();
                if (containerMap.containsKey(key)) {
                    Object object = containerMap.get(key);
                    try {
                        objectList.add(URLEncoder.encode((String)object, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue;
                }
                objectList.add(null);
            }
        }
        return objectList.toArray();
    }
}

