/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base;

import com.paypal.base.AuthenticationStrategy;
import com.paypal.base.credential.CertificateCredential;
import com.paypal.base.credential.TokenAuthorization;
import com.paypal.base.exception.OAuthException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractCertificateHttpHeaderAuthStrategy
implements AuthenticationStrategy<Map<String, String>, CertificateCredential> {
    protected String endPointUrl;

    public AbstractCertificateHttpHeaderAuthStrategy(String endPointUrl) {
        this.endPointUrl = endPointUrl;
    }

    @Override
    public Map<String, String> generateHeaderStrategy(CertificateCredential credential) throws OAuthException {
        HashMap<String, String> headers = null;
        if (credential.getThirdPartyAuthorization() instanceof TokenAuthorization) {
            headers = this.processTokenAuthorization(credential, (TokenAuthorization)credential.getThirdPartyAuthorization());
        } else {
            headers = new HashMap<String, String>();
            headers.put("X-PAYPAL-SECURITY-USERID", credential.getUserName());
            headers.put("X-PAYPAL-SECURITY-PASSWORD", credential.getPassword());
        }
        return headers;
    }

    protected abstract Map<String, String> processTokenAuthorization(CertificateCredential var1, TokenAuthorization var2) throws OAuthException;
}

