/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.base.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.paypal.base.ConfigManager;
import com.paypal.base.ConnectionManager;
import com.paypal.base.HttpConfiguration;
import com.paypal.base.HttpConnection;
import com.paypal.base.SDKUtil;
import com.paypal.base.SDKVersion;
import com.paypal.base.codec.binary.Base64;
import com.paypal.base.credential.ICredential;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.sdk.info.SDKVersionImpl;
import com.paypal.base.util.UserAgentHeader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuthTokenCredential
implements ICredential {
    private static final Logger log = LoggerFactory.getLogger(OAuthTokenCredential.class);
    private static String OAUTH_TOKEN_PATH = "/v1/oauth2/token";
    private String clientID;
    private String clientSecret;
    private String accessToken;
    private Map<String, String> headers;
    private long expires = 0L;
    private Map<String, String> configurationMap;
    private SDKVersion sdkVersion;

    public static void setOAUTH_TOKEN_PATH(String oauthTokenPath) {
        OAUTH_TOKEN_PATH = oauthTokenPath;
    }

    public OAuthTokenCredential(String clientID, String clientSecret) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(ConfigManager.getInstance().getConfigurationMap());
        this.sdkVersion = new SDKVersionImpl();
    }

    public OAuthTokenCredential(String clientID, String clientSecret, Map<String, String> configurationMap) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.configurationMap = SDKUtil.combineDefaultMap(configurationMap);
        this.sdkVersion = new SDKVersionImpl();
    }

    public OAuthTokenCredential setHeaders(Map<String, String> headers) {
        this.headers = headers;
        return this;
    }

    public String getAccessToken() throws PayPalRESTException {
        if (this.accessToken == null) {
            this.accessToken = this.generateAccessToken();
        }
        return this.accessToken;
    }

    public String getAuthorizationHeader() throws PayPalRESTException {
        String base64EncodedString = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        return "Basic " + base64EncodedString;
    }

    public long expiresIn() {
        return this.expires - new Date().getTime() / 1000L;
    }

    private String generateAccessToken() throws PayPalRESTException {
        String generatedToken = null;
        String base64ClientID = this.generateBase64String(this.clientID + ":" + this.clientSecret);
        generatedToken = this.generateOAuthToken(base64ClientID);
        return generatedToken;
    }

    private String generateBase64String(String clientCredentials) throws PayPalRESTException {
        String base64ClientID = null;
        byte[] encoded = null;
        try {
            encoded = Base64.encodeBase64(clientCredentials.getBytes("UTF-8"));
            base64ClientID = new String(encoded, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return base64ClientID;
    }

    private String generateOAuthToken(String base64ClientID) throws PayPalRESTException {
        HttpConnection connection = null;
        HttpConfiguration httpConfiguration = null;
        String generatedToken = null;
        try {
            connection = ConnectionManager.getInstance().getConnection();
            httpConfiguration = this.getOAuthHttpConfiguration();
            connection.createAndconfigureHttpConnection(httpConfiguration);
            if (this.headers == null) {
                this.headers = new HashMap<String, String>();
            }
            this.headers.put("Authorization", "Basic " + base64ClientID);
            this.headers.put("Accept", "application/json");
            this.headers.put("Content-Type", "application/x-www-form-urlencoded");
            UserAgentHeader userAgentHeader = new UserAgentHeader(this.sdkVersion != null ? this.sdkVersion.getSDKId() : null, this.sdkVersion != null ? this.sdkVersion.getSDKVersion() : null);
            this.headers.putAll(userAgentHeader.getHeader());
            String postRequest = this.getRequestPayload();
            String mode = this.configurationMap.get("mode");
            if ("live".equalsIgnoreCase(mode) && log.isDebugEnabled()) {
                log.warn("Log level cannot be set to DEBUG in live mode. Skipping request/response logging...");
            }
            if (!"live".equalsIgnoreCase(mode)) {
                log.debug("request header: " + this.headers.toString());
                log.debug("request body: " + postRequest);
            }
            String jsonResponse = connection.execute("", postRequest, this.headers);
            if (!"live".equalsIgnoreCase(mode)) {
                log.debug("response header: " + connection.getResponseHeaderMap().toString());
                log.debug("response: " + jsonResponse.toString());
            }
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse(jsonResponse);
            generatedToken = jsonElement.getAsJsonObject().get("token_type").getAsString() + " " + jsonElement.getAsJsonObject().get("access_token").getAsString();
            long tokenLifeTime = jsonElement.getAsJsonObject().get("expires_in").getAsLong();
            this.expires = new Date().getTime() / 1000L + tokenLifeTime;
        }
        catch (Exception e) {
            throw new PayPalRESTException(e.getMessage(), e);
        }
        return generatedToken;
    }

    protected String getRequestPayload() {
        return "grant_type=client_credentials";
    }

    private HttpConfiguration getOAuthHttpConfiguration() {
        String endPointUrl;
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        httpConfiguration.setHttpMethod("POST");
        String string = endPointUrl = this.configurationMap.get("oauth.EndPoint") != null && this.configurationMap.get("oauth.EndPoint").trim().length() >= 0 ? this.configurationMap.get("oauth.EndPoint") : this.configurationMap.get("service.EndPoint");
        if (endPointUrl == null || endPointUrl.trim().length() <= 0) {
            String mode = this.configurationMap.get("mode");
            if ("sandbox".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.sandbox.paypal.com/";
            } else if ("live".equalsIgnoreCase(mode)) {
                endPointUrl = "https://api.paypal.com/";
            }
        }
        if (Boolean.parseBoolean(this.configurationMap.get("http.UseProxy"))) {
            httpConfiguration.setProxySet(true);
            httpConfiguration.setProxyHost(this.configurationMap.get("http.ProxyHost"));
            httpConfiguration.setProxyPort(Integer.parseInt(this.configurationMap.get("http.ProxyPort")));
            String proxyUserName = this.configurationMap.get("http.ProxyUserName");
            String proxyPassword = this.configurationMap.get("http.ProxyPassword");
            if (proxyUserName != null && proxyPassword != null) {
                httpConfiguration.setProxyUserName(proxyUserName);
                httpConfiguration.setProxyPassword(proxyPassword);
            }
        }
        endPointUrl = endPointUrl.endsWith("/") ? endPointUrl.substring(0, endPointUrl.length() - 1) : endPointUrl;
        endPointUrl = endPointUrl + OAUTH_TOKEN_PATH;
        httpConfiguration.setEndPointUrl(endPointUrl);
        httpConfiguration.setGoogleAppEngine(Boolean.parseBoolean(this.configurationMap.get("http.GoogleAppEngine")));
        return httpConfiguration;
    }
}

