/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.api.openidconnect.CreateFromRefreshTokenParameters;
import com.paypal.api.openidconnect.Tokeninfo;
import com.paypal.api.payments.Payment;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.PayPalRESTException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;

public class FuturePayment
extends Payment {
    public Payment create(String accessToken, String correlationId) throws PayPalRESTException, FileNotFoundException, IOException {
        if (correlationId == null || correlationId.equals("")) {
            throw new IllegalArgumentException("correlation ID cannot be null or empty");
        }
        APIContext apiContext = new APIContext(accessToken);
        apiContext.setHTTPHeaders(new HashMap<String, String>());
        apiContext.getHTTPHeaders().put("PAYPAL-CLIENT-METADATA-ID", correlationId);
        return this.create(apiContext);
    }

    public Tokeninfo getTokeninfo(CreateFromAuthorizationCodeParameters params) throws PayPalRESTException {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        configurationMap.put("clientId", params.getClientID());
        configurationMap.put("clientSecret", params.getClientSecret());
        configurationMap.put("response_type", "token");
        APIContext apiContext = new APIContext();
        apiContext.setConfigurationMap(configurationMap);
        params.setRedirectURI("urn:ietf:wg:oauth:2.0:oob");
        Tokeninfo info = Tokeninfo.createFromAuthorizationCodeForFpp(apiContext, params);
        return info;
    }

    public Tokeninfo getTokeninfo(CreateFromRefreshTokenParameters params, Tokeninfo info) throws PayPalRESTException {
        HashMap<String, String> configurationMap = new HashMap<String, String>();
        APIContext apiContext = new APIContext();
        apiContext.setConfigurationMap(configurationMap);
        info = info.createFromRefreshToken(apiContext, params);
        return info;
    }
}

