// Generated by delombok at Thu Jun 30 10:55:14 CDT 2016
package com.paypal.api.payments;

import com.paypal.api.openidconnect.CreateFromAuthorizationCodeParameters;
import com.paypal.api.openidconnect.Tokeninfo;
import com.paypal.base.rest.*;
import java.util.List;

public class Invoice extends PayPalResource {
	/**
	 * Unique invoice resource identifier.
	 */
	private String id;
	/**
	 * Unique number that appears on the invoice. If left blank will be auto-incremented from the last number. 25 characters max.
	 */
	private String number;
	/**
	 * URI of the invoice resource.
	 */
	private String uri;
	/**
	 * Status of the invoice.
	 */
	private String status;
	/**
	 * Information about the merchant who is sending the invoice.
	 */
	private MerchantInfo merchantInfo;
	/**
	 * Email address of invoice recipient (required) and optional billing information. (Note: We currently only allow one recipient).
	 */
	private List<BillingInfo> billingInfo;
	/**
	 * Shipping information for entities to whom items are being shipped.
	 */
	private ShippingInfo shippingInfo;
	/**
	 * List of items included in the invoice. 100 items max per invoice.
	 */
	private List<InvoiceItem> items;
	/**
	 * Date on which the invoice was enabled. Date format: yyyy-MM-dd z. For example, 2014-02-27 PST
	 */
	private String invoiceDate;
	/**
	 * Optional field to pass payment deadline for the invoice. Either term_type or due_date can be passed, but not both.
	 */
	private PaymentTerm paymentTerm;
	/**
	 * Invoice level discount in percent or amount.
	 */
	private Cost discount;
	/**
	 * Shipping cost in percent or amount.
	 */
	private ShippingCost shippingCost;
	/**
	 * Custom amount applied on an invoice. If a label is included then the amount cannot be empty.
	 */
	private CustomAmount custom;
	/**
	 * Indicates whether tax is calculated before or after a discount. If false (the default), the tax is calculated before a discount. If true, the tax is calculated after a discount.
	 */
	private Boolean taxCalculatedAfterDiscount;
	/**
	 * A flag indicating whether the unit price includes tax. Default is false
	 */
	private Boolean taxInclusive;
	/**
	 * General terms of the invoice. 4000 characters max.
	 */
	private String terms;
	/**
	 * Note to the payer. 4000 characters max.
	 */
	private String note;
	/**
	 * Bookkeeping memo that is private to the merchant. 150 characters max.
	 */
	private String merchantMemo;
	/**
	 * Full URL of an external image to use as the logo. 4000 characters max.
	 */
	private String logoUrl;
	/**
	 * The total amount of the invoice.
	 */
	private Currency totalAmount;
	/**
	 * List of payment details for the invoice.
	 */
	private List<PaymentDetail> paymentDetails;
	/**
	 * List of refund details for the invoice.
	 */
	private List<RefundDetail> refundDetails;
	/**
	 * Audit information for the invoice.
	 */
	private Metadata metadata;

	/**
	 * Default Constructor
	 */
	public Invoice() {
	}

	/**
	 * Parameterized Constructor
	 */
	public Invoice(MerchantInfo merchantInfo) {
		this.merchantInfo = merchantInfo;
	}

	/**
	 * Creates a new invoice Resource.
	 * @deprecated Please use {@link #create(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return Invoice
	 * @throws PayPalRESTException
	 */
	public Invoice create(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return create(apiContext);
	}

	/**
	 * Creates a new invoice Resource.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @return Invoice
	 * @throws PayPalRESTException
	 */
	public Invoice create(APIContext apiContext) throws PayPalRESTException {
		String resourcePath = "v1/invoicing/invoices";
		String payLoad = this.toJSON();
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Invoice.class);
	}

	/**
	 * Search for invoice resources.
	 * @deprecated Please use {@link #search(APIContext, Search)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param search
	 * Search
	 * @return Invoices
	 * @throws PayPalRESTException
	 */
	public Invoices search(String accessToken, Search search) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return search(apiContext, search);
	}

	/**
	 * Search for invoice resources.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param search
	 * Search
	 * @return Invoices
	 * @throws PayPalRESTException
	 */
	public Invoices search(APIContext apiContext, Search search) throws PayPalRESTException {
		if (search == null) {
			throw new IllegalArgumentException("search cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/search";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = search.toJSON();
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Invoices.class);
	}

	/**
	 * Sends a legitimate invoice to the payer.
	 * @deprecated Please use {@link #send(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @throws PayPalRESTException
	 */
	public void send(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		send(apiContext);
		return;
	}

	/**
	 * Sends a legitimate invoice to the payer.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @throws PayPalRESTException
	 */
	public void send(APIContext apiContext) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/invoices/{0}/send";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
		return;
	}

	/**
	 * Reminds the payer to pay the invoice.
	 * @deprecated Please use {@link #remind(APIContext, Notification)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param notification
	 * Notification
	 * @return 
	 * @throws PayPalRESTException
	 */
	public void remind(String accessToken, Notification notification) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		remind(apiContext, notification);
		return;
	}

	/**
	 * Reminds the payer to pay the invoice.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param notification
	 * Notification
	 * @throws PayPalRESTException
	 */
	public void remind(APIContext apiContext, Notification notification) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (notification == null) {
			throw new IllegalArgumentException("notification cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/invoices/{0}/remind";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = notification.toJSON();
		configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
		return;
	}

	/**
	 * Cancels an invoice.
	 * @deprecated Please use {@link #cancel(APIContext, CancelNotification)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param cancelNotification
	 * CancelNotification
	 * @return 
	 * @throws PayPalRESTException
	 */
	public void cancel(String accessToken, CancelNotification cancelNotification) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		cancel(apiContext, cancelNotification);
		return;
	}

	/**
	 * Cancels an invoice.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param cancelNotification
	 * CancelNotification
	 * @throws PayPalRESTException
	 */
	public void cancel(APIContext apiContext, CancelNotification cancelNotification) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (cancelNotification == null) {
			throw new IllegalArgumentException("cancelNotification cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/invoices/{0}/cancel";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = cancelNotification.toJSON();
		configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
		return;
	}

	/**
	 * Mark the status of the invoice as paid.
	 * @deprecated Please use {@link #recordPayment(APIContext, PaymentDetail)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param paymentDetail
	 * PaymentDetail
	 * @throws PayPalRESTException
	 */
	public void recordPayment(String accessToken, PaymentDetail paymentDetail) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		recordPayment(apiContext, paymentDetail);
		return;
	}

	/**
	 * Mark the status of the invoice as paid.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param paymentDetail
	 * PaymentDetail
	 * @throws PayPalRESTException
	 */
	public void recordPayment(APIContext apiContext, PaymentDetail paymentDetail) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (paymentDetail == null) {
			throw new IllegalArgumentException("paymentDetail cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/invoices/{0}/record-payment";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = paymentDetail.toJSON();
		configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
		return;
	}

	/**
	 * Mark the status of the invoice as refunded.
	 * @deprecated Please use {@link #recordRefund(APIContext, RefundDetail)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param refundDetail
	 * RefundDetail
	 * @throws PayPalRESTException
	 */
	public void recordRefund(String accessToken, RefundDetail refundDetail) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		recordRefund(apiContext, refundDetail);
		return;
	}

	/**
	 * Mark the status of the invoice as refunded.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param refundDetail
	 * RefundDetail
	 * @throws PayPalRESTException
	 */
	public void recordRefund(APIContext apiContext, RefundDetail refundDetail) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (refundDetail == null) {
			throw new IllegalArgumentException("refundDetail cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/invoices/{0}/record-refund";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = refundDetail.toJSON();
		configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
		return;
	}

	/**
	 * Get the invoice resource for the given identifier.
	 * @deprecated Please use {@link #get(APIContext, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param invoiceId
	 * String
	 * @return Invoice
	 * @throws PayPalRESTException
	 */
	public static Invoice get(String accessToken, String invoiceId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return get(apiContext, invoiceId);
	}

	/**
	 * Get the invoice resource for the given identifier.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param invoiceId
	 * String
	 * @return Invoice
	 * @throws PayPalRESTException
	 */
	public static Invoice get(APIContext apiContext, String invoiceId) throws PayPalRESTException {
		if (invoiceId == null) {
			throw new IllegalArgumentException("invoiceId cannot be null");
		}
		Object[] parameters = new Object[] {invoiceId};
		String pattern = "v1/invoicing/invoices/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Invoice.class);
	}

	/**
	 * Get all invoices of a merchant.
	 * @deprecated Please use {@link #getAll(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return Invoices
	 * @throws PayPalRESTException
	 */
	public static Invoices getAll(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return getAll(apiContext);
	}

	/**
	 * Get all invoices of a merchant.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @return Invoices
	 * @throws PayPalRESTException
	 */
	public static Invoices getAll(APIContext apiContext) throws PayPalRESTException {
		String resourcePath = "v1/invoicing/invoices";
		String payLoad = "";
		Invoices invoices = configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Invoices.class);
		return invoices;
	}

	/**
	 * Full update of the invoice resource for the given identifier.
	 * @deprecated Please use {@link #update(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return Invoice
	 * @throws PayPalRESTException
	 */
	public Invoice update(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return update(apiContext);
	}

	/**
	 * Full update of the invoice resource for the given identifier.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @return Invoice
	 * @throws PayPalRESTException
	 */
	public Invoice update(APIContext apiContext) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/invoices/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = this.toJSON();
		return configureAndExecute(apiContext, HttpMethod.PUT, resourcePath, payLoad, Invoice.class);
	}

	/**
	 * Delete invoice resource for the given identifier.
	 * @deprecated Please use {@link #delete(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @throws PayPalRESTException
	 */
	public void delete(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		delete(apiContext);
		return;
	}

	/**
	 * Delete invoice resource for the given identifier.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @throws PayPalRESTException
	 */
	public void delete(APIContext apiContext) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		apiContext.setMaskRequestId(true);
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/invoicing/invoices/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
		return;
	}

	/**
	 * Fetches long lived refresh token from authorization code, for third party merchant invoicing use. 
	 *
	 * @param context
	 * @param authorizationCode
	 * @return {@link String} Refresh Token
	 * @throws PayPalRESTException
	 */
	public static String fetchRefreshToken(APIContext context, String authorizationCode) throws PayPalRESTException {
		CreateFromAuthorizationCodeParameters params = new CreateFromAuthorizationCodeParameters();
		params.setClientID(context.getClientID());
		params.setClientSecret(context.getClientSecret());
		params.setCode(authorizationCode);
		params.setGrantType("authorization_code");
		Tokeninfo info = Tokeninfo.createFromAuthorizationCode(context, params);
		return info.getRefreshToken();
	}

	/**
	 * Unique invoice resource identifier.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Unique number that appears on the invoice. If left blank will be auto-incremented from the last number. 25 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getNumber() {
		return this.number;
	}

	/**
	 * URI of the invoice resource.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUri() {
		return this.uri;
	}

	/**
	 * Status of the invoice.
	 */
	@java.lang.SuppressWarnings("all")
	public String getStatus() {
		return this.status;
	}

	/**
	 * Information about the merchant who is sending the invoice.
	 */
	@java.lang.SuppressWarnings("all")
	public MerchantInfo getMerchantInfo() {
		return this.merchantInfo;
	}

	/**
	 * Email address of invoice recipient (required) and optional billing information. (Note: We currently only allow one recipient).
	 */
	@java.lang.SuppressWarnings("all")
	public List<BillingInfo> getBillingInfo() {
		return this.billingInfo;
	}

	/**
	 * Shipping information for entities to whom items are being shipped.
	 */
	@java.lang.SuppressWarnings("all")
	public ShippingInfo getShippingInfo() {
		return this.shippingInfo;
	}

	/**
	 * List of items included in the invoice. 100 items max per invoice.
	 */
	@java.lang.SuppressWarnings("all")
	public List<InvoiceItem> getItems() {
		return this.items;
	}

	/**
	 * Date on which the invoice was enabled. Date format: yyyy-MM-dd z. For example, 2014-02-27 PST
	 */
	@java.lang.SuppressWarnings("all")
	public String getInvoiceDate() {
		return this.invoiceDate;
	}

	/**
	 * Optional field to pass payment deadline for the invoice. Either term_type or due_date can be passed, but not both.
	 */
	@java.lang.SuppressWarnings("all")
	public PaymentTerm getPaymentTerm() {
		return this.paymentTerm;
	}

	/**
	 * Invoice level discount in percent or amount.
	 */
	@java.lang.SuppressWarnings("all")
	public Cost getDiscount() {
		return this.discount;
	}

	/**
	 * Shipping cost in percent or amount.
	 */
	@java.lang.SuppressWarnings("all")
	public ShippingCost getShippingCost() {
		return this.shippingCost;
	}

	/**
	 * Custom amount applied on an invoice. If a label is included then the amount cannot be empty.
	 */
	@java.lang.SuppressWarnings("all")
	public CustomAmount getCustom() {
		return this.custom;
	}

	/**
	 * Indicates whether tax is calculated before or after a discount. If false (the default), the tax is calculated before a discount. If true, the tax is calculated after a discount.
	 */
	@java.lang.SuppressWarnings("all")
	public Boolean getTaxCalculatedAfterDiscount() {
		return this.taxCalculatedAfterDiscount;
	}

	/**
	 * A flag indicating whether the unit price includes tax. Default is false
	 */
	@java.lang.SuppressWarnings("all")
	public Boolean getTaxInclusive() {
		return this.taxInclusive;
	}

	/**
	 * General terms of the invoice. 4000 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getTerms() {
		return this.terms;
	}

	/**
	 * Note to the payer. 4000 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getNote() {
		return this.note;
	}

	/**
	 * Bookkeeping memo that is private to the merchant. 150 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getMerchantMemo() {
		return this.merchantMemo;
	}

	/**
	 * Full URL of an external image to use as the logo. 4000 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getLogoUrl() {
		return this.logoUrl;
	}

	/**
	 * The total amount of the invoice.
	 */
	@java.lang.SuppressWarnings("all")
	public Currency getTotalAmount() {
		return this.totalAmount;
	}

	/**
	 * List of payment details for the invoice.
	 */
	@java.lang.SuppressWarnings("all")
	public List<PaymentDetail> getPaymentDetails() {
		return this.paymentDetails;
	}

	/**
	 * List of refund details for the invoice.
	 */
	@java.lang.SuppressWarnings("all")
	public List<RefundDetail> getRefundDetails() {
		return this.refundDetails;
	}

	/**
	 * Audit information for the invoice.
	 */
	@java.lang.SuppressWarnings("all")
	public Metadata getMetadata() {
		return this.metadata;
	}

	/**
	 * Unique invoice resource identifier.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Unique number that appears on the invoice. If left blank will be auto-incremented from the last number. 25 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setNumber(final String number) {
		this.number = number;
		return this;
	}

	/**
	 * URI of the invoice resource.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setUri(final String uri) {
		this.uri = uri;
		return this;
	}

	/**
	 * Status of the invoice.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setStatus(final String status) {
		this.status = status;
		return this;
	}

	/**
	 * Information about the merchant who is sending the invoice.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setMerchantInfo(final MerchantInfo merchantInfo) {
		this.merchantInfo = merchantInfo;
		return this;
	}

	/**
	 * Email address of invoice recipient (required) and optional billing information. (Note: We currently only allow one recipient).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setBillingInfo(final List<BillingInfo> billingInfo) {
		this.billingInfo = billingInfo;
		return this;
	}

	/**
	 * Shipping information for entities to whom items are being shipped.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setShippingInfo(final ShippingInfo shippingInfo) {
		this.shippingInfo = shippingInfo;
		return this;
	}

	/**
	 * List of items included in the invoice. 100 items max per invoice.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setItems(final List<InvoiceItem> items) {
		this.items = items;
		return this;
	}

	/**
	 * Date on which the invoice was enabled. Date format: yyyy-MM-dd z. For example, 2014-02-27 PST
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setInvoiceDate(final String invoiceDate) {
		this.invoiceDate = invoiceDate;
		return this;
	}

	/**
	 * Optional field to pass payment deadline for the invoice. Either term_type or due_date can be passed, but not both.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setPaymentTerm(final PaymentTerm paymentTerm) {
		this.paymentTerm = paymentTerm;
		return this;
	}

	/**
	 * Invoice level discount in percent or amount.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setDiscount(final Cost discount) {
		this.discount = discount;
		return this;
	}

	/**
	 * Shipping cost in percent or amount.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setShippingCost(final ShippingCost shippingCost) {
		this.shippingCost = shippingCost;
		return this;
	}

	/**
	 * Custom amount applied on an invoice. If a label is included then the amount cannot be empty.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setCustom(final CustomAmount custom) {
		this.custom = custom;
		return this;
	}

	/**
	 * Indicates whether tax is calculated before or after a discount. If false (the default), the tax is calculated before a discount. If true, the tax is calculated after a discount.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setTaxCalculatedAfterDiscount(final Boolean taxCalculatedAfterDiscount) {
		this.taxCalculatedAfterDiscount = taxCalculatedAfterDiscount;
		return this;
	}

	/**
	 * A flag indicating whether the unit price includes tax. Default is false
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setTaxInclusive(final Boolean taxInclusive) {
		this.taxInclusive = taxInclusive;
		return this;
	}

	/**
	 * General terms of the invoice. 4000 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setTerms(final String terms) {
		this.terms = terms;
		return this;
	}

	/**
	 * Note to the payer. 4000 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setNote(final String note) {
		this.note = note;
		return this;
	}

	/**
	 * Bookkeeping memo that is private to the merchant. 150 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setMerchantMemo(final String merchantMemo) {
		this.merchantMemo = merchantMemo;
		return this;
	}

	/**
	 * Full URL of an external image to use as the logo. 4000 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setLogoUrl(final String logoUrl) {
		this.logoUrl = logoUrl;
		return this;
	}

	/**
	 * The total amount of the invoice.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setTotalAmount(final Currency totalAmount) {
		this.totalAmount = totalAmount;
		return this;
	}

	/**
	 * List of payment details for the invoice.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setPaymentDetails(final List<PaymentDetail> paymentDetails) {
		this.paymentDetails = paymentDetails;
		return this;
	}

	/**
	 * List of refund details for the invoice.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setRefundDetails(final List<RefundDetail> refundDetails) {
		this.refundDetails = refundDetails;
		return this;
	}

	/**
	 * Audit information for the invoice.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Invoice setMetadata(final Metadata metadata) {
		this.metadata = metadata;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof Invoice)) return false;
		final Invoice other = (Invoice) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$number = this.getNumber();
		final java.lang.Object other$number = other.getNumber();
		if (this$number == null ? other$number != null : !this$number.equals(other$number)) return false;
		final java.lang.Object this$uri = this.getUri();
		final java.lang.Object other$uri = other.getUri();
		if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) return false;
		final java.lang.Object this$status = this.getStatus();
		final java.lang.Object other$status = other.getStatus();
		if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
		final java.lang.Object this$merchantInfo = this.getMerchantInfo();
		final java.lang.Object other$merchantInfo = other.getMerchantInfo();
		if (this$merchantInfo == null ? other$merchantInfo != null : !this$merchantInfo.equals(other$merchantInfo)) return false;
		final java.lang.Object this$billingInfo = this.getBillingInfo();
		final java.lang.Object other$billingInfo = other.getBillingInfo();
		if (this$billingInfo == null ? other$billingInfo != null : !this$billingInfo.equals(other$billingInfo)) return false;
		final java.lang.Object this$shippingInfo = this.getShippingInfo();
		final java.lang.Object other$shippingInfo = other.getShippingInfo();
		if (this$shippingInfo == null ? other$shippingInfo != null : !this$shippingInfo.equals(other$shippingInfo)) return false;
		final java.lang.Object this$items = this.getItems();
		final java.lang.Object other$items = other.getItems();
		if (this$items == null ? other$items != null : !this$items.equals(other$items)) return false;
		final java.lang.Object this$invoiceDate = this.getInvoiceDate();
		final java.lang.Object other$invoiceDate = other.getInvoiceDate();
		if (this$invoiceDate == null ? other$invoiceDate != null : !this$invoiceDate.equals(other$invoiceDate)) return false;
		final java.lang.Object this$paymentTerm = this.getPaymentTerm();
		final java.lang.Object other$paymentTerm = other.getPaymentTerm();
		if (this$paymentTerm == null ? other$paymentTerm != null : !this$paymentTerm.equals(other$paymentTerm)) return false;
		final java.lang.Object this$discount = this.getDiscount();
		final java.lang.Object other$discount = other.getDiscount();
		if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
		final java.lang.Object this$shippingCost = this.getShippingCost();
		final java.lang.Object other$shippingCost = other.getShippingCost();
		if (this$shippingCost == null ? other$shippingCost != null : !this$shippingCost.equals(other$shippingCost)) return false;
		final java.lang.Object this$custom = this.getCustom();
		final java.lang.Object other$custom = other.getCustom();
		if (this$custom == null ? other$custom != null : !this$custom.equals(other$custom)) return false;
		final java.lang.Object this$taxCalculatedAfterDiscount = this.getTaxCalculatedAfterDiscount();
		final java.lang.Object other$taxCalculatedAfterDiscount = other.getTaxCalculatedAfterDiscount();
		if (this$taxCalculatedAfterDiscount == null ? other$taxCalculatedAfterDiscount != null : !this$taxCalculatedAfterDiscount.equals(other$taxCalculatedAfterDiscount)) return false;
		final java.lang.Object this$taxInclusive = this.getTaxInclusive();
		final java.lang.Object other$taxInclusive = other.getTaxInclusive();
		if (this$taxInclusive == null ? other$taxInclusive != null : !this$taxInclusive.equals(other$taxInclusive)) return false;
		final java.lang.Object this$terms = this.getTerms();
		final java.lang.Object other$terms = other.getTerms();
		if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) return false;
		final java.lang.Object this$note = this.getNote();
		final java.lang.Object other$note = other.getNote();
		if (this$note == null ? other$note != null : !this$note.equals(other$note)) return false;
		final java.lang.Object this$merchantMemo = this.getMerchantMemo();
		final java.lang.Object other$merchantMemo = other.getMerchantMemo();
		if (this$merchantMemo == null ? other$merchantMemo != null : !this$merchantMemo.equals(other$merchantMemo)) return false;
		final java.lang.Object this$logoUrl = this.getLogoUrl();
		final java.lang.Object other$logoUrl = other.getLogoUrl();
		if (this$logoUrl == null ? other$logoUrl != null : !this$logoUrl.equals(other$logoUrl)) return false;
		final java.lang.Object this$totalAmount = this.getTotalAmount();
		final java.lang.Object other$totalAmount = other.getTotalAmount();
		if (this$totalAmount == null ? other$totalAmount != null : !this$totalAmount.equals(other$totalAmount)) return false;
		final java.lang.Object this$paymentDetails = this.getPaymentDetails();
		final java.lang.Object other$paymentDetails = other.getPaymentDetails();
		if (this$paymentDetails == null ? other$paymentDetails != null : !this$paymentDetails.equals(other$paymentDetails)) return false;
		final java.lang.Object this$refundDetails = this.getRefundDetails();
		final java.lang.Object other$refundDetails = other.getRefundDetails();
		if (this$refundDetails == null ? other$refundDetails != null : !this$refundDetails.equals(other$refundDetails)) return false;
		final java.lang.Object this$metadata = this.getMetadata();
		final java.lang.Object other$metadata = other.getMetadata();
		if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof Invoice;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $number = this.getNumber();
		result = result * PRIME + ($number == null ? 43 : $number.hashCode());
		final java.lang.Object $uri = this.getUri();
		result = result * PRIME + ($uri == null ? 43 : $uri.hashCode());
		final java.lang.Object $status = this.getStatus();
		result = result * PRIME + ($status == null ? 43 : $status.hashCode());
		final java.lang.Object $merchantInfo = this.getMerchantInfo();
		result = result * PRIME + ($merchantInfo == null ? 43 : $merchantInfo.hashCode());
		final java.lang.Object $billingInfo = this.getBillingInfo();
		result = result * PRIME + ($billingInfo == null ? 43 : $billingInfo.hashCode());
		final java.lang.Object $shippingInfo = this.getShippingInfo();
		result = result * PRIME + ($shippingInfo == null ? 43 : $shippingInfo.hashCode());
		final java.lang.Object $items = this.getItems();
		result = result * PRIME + ($items == null ? 43 : $items.hashCode());
		final java.lang.Object $invoiceDate = this.getInvoiceDate();
		result = result * PRIME + ($invoiceDate == null ? 43 : $invoiceDate.hashCode());
		final java.lang.Object $paymentTerm = this.getPaymentTerm();
		result = result * PRIME + ($paymentTerm == null ? 43 : $paymentTerm.hashCode());
		final java.lang.Object $discount = this.getDiscount();
		result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
		final java.lang.Object $shippingCost = this.getShippingCost();
		result = result * PRIME + ($shippingCost == null ? 43 : $shippingCost.hashCode());
		final java.lang.Object $custom = this.getCustom();
		result = result * PRIME + ($custom == null ? 43 : $custom.hashCode());
		final java.lang.Object $taxCalculatedAfterDiscount = this.getTaxCalculatedAfterDiscount();
		result = result * PRIME + ($taxCalculatedAfterDiscount == null ? 43 : $taxCalculatedAfterDiscount.hashCode());
		final java.lang.Object $taxInclusive = this.getTaxInclusive();
		result = result * PRIME + ($taxInclusive == null ? 43 : $taxInclusive.hashCode());
		final java.lang.Object $terms = this.getTerms();
		result = result * PRIME + ($terms == null ? 43 : $terms.hashCode());
		final java.lang.Object $note = this.getNote();
		result = result * PRIME + ($note == null ? 43 : $note.hashCode());
		final java.lang.Object $merchantMemo = this.getMerchantMemo();
		result = result * PRIME + ($merchantMemo == null ? 43 : $merchantMemo.hashCode());
		final java.lang.Object $logoUrl = this.getLogoUrl();
		result = result * PRIME + ($logoUrl == null ? 43 : $logoUrl.hashCode());
		final java.lang.Object $totalAmount = this.getTotalAmount();
		result = result * PRIME + ($totalAmount == null ? 43 : $totalAmount.hashCode());
		final java.lang.Object $paymentDetails = this.getPaymentDetails();
		result = result * PRIME + ($paymentDetails == null ? 43 : $paymentDetails.hashCode());
		final java.lang.Object $refundDetails = this.getRefundDetails();
		result = result * PRIME + ($refundDetails == null ? 43 : $refundDetails.hashCode());
		final java.lang.Object $metadata = this.getMetadata();
		result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
		return result;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public java.lang.String toString() {
		return "Invoice(id=" + this.getId() + ", number=" + this.getNumber() + ", uri=" + this.getUri() + ", status=" + this.getStatus() + ", merchantInfo=" + this.getMerchantInfo() + ", billingInfo=" + this.getBillingInfo() + ", shippingInfo=" + this.getShippingInfo() + ", items=" + this.getItems() + ", invoiceDate=" + this.getInvoiceDate() + ", paymentTerm=" + this.getPaymentTerm() + ", discount=" + this.getDiscount() + ", shippingCost=" + this.getShippingCost() + ", custom=" + this.getCustom() + ", taxCalculatedAfterDiscount=" + this.getTaxCalculatedAfterDiscount() + ", taxInclusive=" + this.getTaxInclusive() + ", terms=" + this.getTerms() + ", note=" + this.getNote() + ", merchantMemo=" + this.getMerchantMemo() + ", logoUrl=" + this.getLogoUrl() + ", totalAmount=" + this.getTotalAmount() + ", paymentDetails=" + this.getPaymentDetails() + ", refundDetails=" + this.getRefundDetails() + ", metadata=" + this.getMetadata() + ")";
	}
}
