// Generated by delombok at Thu Jun 30 10:55:14 CDT 2016
package com.paypal.api.payments;

import com.paypal.base.rest.PayPalModel;

public class InvoiceItem extends PayPalModel {
	/**
	 * Name of the item. 60 characters max.
	 */
	private String name;
	/**
	 * Description of the item. 1000 characters max.
	 */
	private String description;
	/**
	 * Quantity of the item. Range of 0 to 9999.999.
	 */
	private float quantity;
	/**
	 * Unit price of the item. Range of -999999.99 to 999999.99.
	 */
	private Currency unitPrice;
	/**
	 * Tax associated with the item.
	 */
	private Tax tax;
	/**
	 * Date on which the item or service was provided. Date format: yyyy-MM-dd z. For example, 2014-02-27 PST.
	 */
	private String date;
	/**
	 * Item discount in percent or amount.
	 */
	private Cost discount;

	/**
	 * Default Constructor
	 */
	public InvoiceItem() {
	}

	/**
	 * Parameterized Constructor
	 */
	public InvoiceItem(String name, float quantity, Currency unitPrice) {
		this.name = name;
		this.quantity = quantity;
		this.unitPrice = unitPrice;
	}

	/**
	 * Name of the item. 60 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getName() {
		return this.name;
	}

	/**
	 * Description of the item. 1000 characters max.
	 */
	@java.lang.SuppressWarnings("all")
	public String getDescription() {
		return this.description;
	}

	/**
	 * Quantity of the item. Range of 0 to 9999.999.
	 */
	@java.lang.SuppressWarnings("all")
	public float getQuantity() {
		return this.quantity;
	}

	/**
	 * Unit price of the item. Range of -999999.99 to 999999.99.
	 */
	@java.lang.SuppressWarnings("all")
	public Currency getUnitPrice() {
		return this.unitPrice;
	}

	/**
	 * Tax associated with the item.
	 */
	@java.lang.SuppressWarnings("all")
	public Tax getTax() {
		return this.tax;
	}

	/**
	 * Date on which the item or service was provided. Date format: yyyy-MM-dd z. For example, 2014-02-27 PST.
	 */
	@java.lang.SuppressWarnings("all")
	public String getDate() {
		return this.date;
	}

	/**
	 * Item discount in percent or amount.
	 */
	@java.lang.SuppressWarnings("all")
	public Cost getDiscount() {
		return this.discount;
	}

	/**
	 * Name of the item. 60 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setName(final String name) {
		this.name = name;
		return this;
	}

	/**
	 * Description of the item. 1000 characters max.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setDescription(final String description) {
		this.description = description;
		return this;
	}

	/**
	 * Quantity of the item. Range of 0 to 9999.999.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setQuantity(final float quantity) {
		this.quantity = quantity;
		return this;
	}

	/**
	 * Unit price of the item. Range of -999999.99 to 999999.99.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setUnitPrice(final Currency unitPrice) {
		this.unitPrice = unitPrice;
		return this;
	}

	/**
	 * Tax associated with the item.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setTax(final Tax tax) {
		this.tax = tax;
		return this;
	}

	/**
	 * Date on which the item or service was provided. Date format: yyyy-MM-dd z. For example, 2014-02-27 PST.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setDate(final String date) {
		this.date = date;
		return this;
	}

	/**
	 * Item discount in percent or amount.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public InvoiceItem setDiscount(final Cost discount) {
		this.discount = discount;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof InvoiceItem)) return false;
		final InvoiceItem other = (InvoiceItem) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		final java.lang.Object this$name = this.getName();
		final java.lang.Object other$name = other.getName();
		if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
		final java.lang.Object this$description = this.getDescription();
		final java.lang.Object other$description = other.getDescription();
		if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
		if (java.lang.Float.compare(this.getQuantity(), other.getQuantity()) != 0) return false;
		final java.lang.Object this$unitPrice = this.getUnitPrice();
		final java.lang.Object other$unitPrice = other.getUnitPrice();
		if (this$unitPrice == null ? other$unitPrice != null : !this$unitPrice.equals(other$unitPrice)) return false;
		final java.lang.Object this$tax = this.getTax();
		final java.lang.Object other$tax = other.getTax();
		if (this$tax == null ? other$tax != null : !this$tax.equals(other$tax)) return false;
		final java.lang.Object this$date = this.getDate();
		final java.lang.Object other$date = other.getDate();
		if (this$date == null ? other$date != null : !this$date.equals(other$date)) return false;
		final java.lang.Object this$discount = this.getDiscount();
		final java.lang.Object other$discount = other.getDiscount();
		if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof InvoiceItem;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		final java.lang.Object $name = this.getName();
		result = result * PRIME + ($name == null ? 43 : $name.hashCode());
		final java.lang.Object $description = this.getDescription();
		result = result * PRIME + ($description == null ? 43 : $description.hashCode());
		result = result * PRIME + java.lang.Float.floatToIntBits(this.getQuantity());
		final java.lang.Object $unitPrice = this.getUnitPrice();
		result = result * PRIME + ($unitPrice == null ? 43 : $unitPrice.hashCode());
		final java.lang.Object $tax = this.getTax();
		result = result * PRIME + ($tax == null ? 43 : $tax.hashCode());
		final java.lang.Object $date = this.getDate();
		result = result * PRIME + ($date == null ? 43 : $date.hashCode());
		final java.lang.Object $discount = this.getDiscount();
		result = result * PRIME + ($discount == null ? 43 : $discount.hashCode());
		return result;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public java.lang.String toString() {
		return "InvoiceItem(name=" + this.getName() + ", description=" + this.getDescription() + ", quantity=" + this.getQuantity() + ", unitPrice=" + this.getUnitPrice() + ", tax=" + this.getTax() + ", date=" + this.getDate() + ", discount=" + this.getDiscount() + ")";
	}
}
