/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.Address;
import com.paypal.api.payments.AgreementDetails;
import com.paypal.api.payments.AgreementStateDescriptor;
import com.paypal.api.payments.AgreementTransactions;
import com.paypal.api.payments.Currency;
import com.paypal.api.payments.Links;
import com.paypal.api.payments.MerchantPreferences;
import com.paypal.api.payments.OverrideChargeModel;
import com.paypal.api.payments.Patch;
import com.paypal.api.payments.Payer;
import com.paypal.api.payments.Plan;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.JSONFormatter;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Agreement
extends PayPalResource {
    private String id;
    private String state;
    private String name;
    private String description;
    private String startDate;
    private AgreementDetails agreementDetails;
    private Payer payer;
    private Address shippingAddress;
    private MerchantPreferences overrideMerchantPreferences;
    private List<OverrideChargeModel> overrideChargeModels;
    private Plan plan;
    private String createTime;
    private String updateTime;
    private String token;
    private List<Links> links;

    public Agreement() {
    }

    public Agreement(String name, String description, String startDate, Payer payer, Plan plan) {
        this.name = name;
        this.description = description;
        this.startDate = startDate;
        this.payer = payer;
        this.plan = plan;
    }

    public Agreement create(String accessToken) throws PayPalRESTException, MalformedURLException, UnsupportedEncodingException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public Agreement create(APIContext apiContext) throws PayPalRESTException, MalformedURLException, UnsupportedEncodingException {
        String resourcePath = "v1/payments/billing-agreements";
        String payLoad = this.toJSON();
        Agreement agreement = Agreement.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Agreement.class);
        for (Links links : agreement.getLinks()) {
            if (!"approval_url".equals(links.getRel())) continue;
            URL url = new URL(links.getHref());
            agreement.setToken(Agreement.splitQuery(url).get("token"));
            break;
        }
        return agreement;
    }

    private static Map<String, String> splitQuery(URL url) throws UnsupportedEncodingException {
        String[] pairs;
        HashMap<String, String> queryPairs = new HashMap<String, String>();
        String query = url.getQuery();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return queryPairs;
    }

    public Agreement execute(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Agreement.execute(apiContext, this.getToken());
    }

    public static Agreement execute(APIContext apiContext, String token) throws PayPalRESTException {
        Object[] parameters = new Object[]{token};
        String pattern = "v1/payments/billing-agreements/{0}/agreement-execute";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Agreement.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Agreement.class);
    }

    public static Agreement get(String accessToken, String agreementId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Agreement.get(apiContext, agreementId);
    }

    public static Agreement get(APIContext apiContext, String agreementId) throws PayPalRESTException {
        if (agreementId == null) {
            throw new IllegalArgumentException("agreementId cannot be null");
        }
        Object[] parameters = new Object[]{agreementId};
        String pattern = "v1/payments/billing-agreements/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Agreement.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Agreement.class);
    }

    public Agreement update(String accessToken, List<Patch> patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.update(apiContext, patchRequest);
    }

    public Agreement update(APIContext apiContext, List<Patch> patchRequest) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = JSONFormatter.toJSON(patchRequest);
        return Agreement.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, Agreement.class);
    }

    public void suspend(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.suspend(apiContext, agreementStateDescriptor);
    }

    public void suspend(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/suspend";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        Agreement.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void reActivate(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.reActivate(apiContext, agreementStateDescriptor);
    }

    public void reActivate(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/re-activate";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        Agreement.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void cancel(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.cancel(apiContext, agreementStateDescriptor);
    }

    public void cancel(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/cancel";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        Agreement.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void billBalance(String accessToken, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.billBalance(apiContext, agreementStateDescriptor);
    }

    public void billBalance(APIContext apiContext, AgreementStateDescriptor agreementStateDescriptor) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (agreementStateDescriptor == null) {
            throw new IllegalArgumentException("agreementStateDescriptor cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/bill-balance";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = agreementStateDescriptor.toJSON();
        Agreement.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public void setBalance(String accessToken, Currency currency) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.setBalance(apiContext, currency);
    }

    public void setBalance(APIContext apiContext, Currency currency) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (currency == null) {
            throw new IllegalArgumentException("currency cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payments/billing-agreements/{0}/set-balance";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = currency.toJSON();
        Agreement.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, null);
    }

    public static AgreementTransactions transactions(String accessToken, String agreementId, Date startDate, Date endDate) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return Agreement.transactions(apiContext, agreementId, startDate, endDate);
    }

    public static AgreementTransactions transactions(APIContext apiContext, String agreementId, Date startDate, Date endDate) throws PayPalRESTException {
        if (startDate == null) {
            throw new IllegalArgumentException("startDate cannot be null");
        }
        if (endDate == null) {
            throw new IllegalArgumentException("endDate cannot be null");
        }
        if (agreementId == null) {
            throw new IllegalArgumentException("agreementId cannot be null");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String sDate = dateFormat.format(startDate);
        String eDate = dateFormat.format(endDate);
        Object[] parameters = new Object[]{agreementId, sDate, eDate};
        String pattern = "v1/payments/billing-agreements/{0}/transactions?start_date={1}&end_date={2}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        AgreementTransactions transactions = Agreement.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, AgreementTransactions.class);
        return transactions;
    }

    public String getId() {
        return this.id;
    }

    public String getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public AgreementDetails getAgreementDetails() {
        return this.agreementDetails;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public MerchantPreferences getOverrideMerchantPreferences() {
        return this.overrideMerchantPreferences;
    }

    public List<OverrideChargeModel> getOverrideChargeModels() {
        return this.overrideChargeModels;
    }

    public Plan getPlan() {
        return this.plan;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getToken() {
        return this.token;
    }

    public List<Links> getLinks() {
        return this.links;
    }

    public Agreement setId(String id) {
        this.id = id;
        return this;
    }

    public Agreement setState(String state) {
        this.state = state;
        return this;
    }

    public Agreement setName(String name) {
        this.name = name;
        return this;
    }

    public Agreement setDescription(String description) {
        this.description = description;
        return this;
    }

    public Agreement setStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    public Agreement setAgreementDetails(AgreementDetails agreementDetails) {
        this.agreementDetails = agreementDetails;
        return this;
    }

    public Agreement setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Agreement setShippingAddress(Address shippingAddress) {
        this.shippingAddress = shippingAddress;
        return this;
    }

    public Agreement setOverrideMerchantPreferences(MerchantPreferences overrideMerchantPreferences) {
        this.overrideMerchantPreferences = overrideMerchantPreferences;
        return this;
    }

    public Agreement setOverrideChargeModels(List<OverrideChargeModel> overrideChargeModels) {
        this.overrideChargeModels = overrideChargeModels;
        return this;
    }

    public Agreement setPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public Agreement setCreateTime(String createTime) {
        this.createTime = createTime;
        return this;
    }

    public Agreement setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public Agreement setToken(String token) {
        this.token = token;
        return this;
    }

    public Agreement setLinks(List<Links> links) {
        this.links = links;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Agreement)) {
            return false;
        }
        Agreement other = (Agreement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$startDate = this.getStartDate();
        String other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate)) {
            return false;
        }
        AgreementDetails this$agreementDetails = this.getAgreementDetails();
        AgreementDetails other$agreementDetails = other.getAgreementDetails();
        if (this$agreementDetails == null ? other$agreementDetails != null : !((Object)this$agreementDetails).equals(other$agreementDetails)) {
            return false;
        }
        Payer this$payer = this.getPayer();
        Payer other$payer = other.getPayer();
        if (this$payer == null ? other$payer != null : !((Object)this$payer).equals(other$payer)) {
            return false;
        }
        Address this$shippingAddress = this.getShippingAddress();
        Address other$shippingAddress = other.getShippingAddress();
        if (this$shippingAddress == null ? other$shippingAddress != null : !((Object)this$shippingAddress).equals(other$shippingAddress)) {
            return false;
        }
        MerchantPreferences this$overrideMerchantPreferences = this.getOverrideMerchantPreferences();
        MerchantPreferences other$overrideMerchantPreferences = other.getOverrideMerchantPreferences();
        if (this$overrideMerchantPreferences == null ? other$overrideMerchantPreferences != null : !((Object)this$overrideMerchantPreferences).equals(other$overrideMerchantPreferences)) {
            return false;
        }
        List<OverrideChargeModel> this$overrideChargeModels = this.getOverrideChargeModels();
        List<OverrideChargeModel> other$overrideChargeModels = other.getOverrideChargeModels();
        if (this$overrideChargeModels == null ? other$overrideChargeModels != null : !((Object)this$overrideChargeModels).equals(other$overrideChargeModels)) {
            return false;
        }
        Plan this$plan = this.getPlan();
        Plan other$plan = other.getPlan();
        if (this$plan == null ? other$plan != null : !((Object)this$plan).equals(other$plan)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$updateTime = this.getUpdateTime();
        String other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        List<Links> this$links = this.getLinks();
        List<Links> other$links = other.getLinks();
        return !(this$links == null ? other$links != null : !((Object)this$links).equals(other$links));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Agreement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
        AgreementDetails $agreementDetails = this.getAgreementDetails();
        result = result * 59 + ($agreementDetails == null ? 43 : ((Object)$agreementDetails).hashCode());
        Payer $payer = this.getPayer();
        result = result * 59 + ($payer == null ? 43 : ((Object)$payer).hashCode());
        Address $shippingAddress = this.getShippingAddress();
        result = result * 59 + ($shippingAddress == null ? 43 : ((Object)$shippingAddress).hashCode());
        MerchantPreferences $overrideMerchantPreferences = this.getOverrideMerchantPreferences();
        result = result * 59 + ($overrideMerchantPreferences == null ? 43 : ((Object)$overrideMerchantPreferences).hashCode());
        List<OverrideChargeModel> $overrideChargeModels = this.getOverrideChargeModels();
        result = result * 59 + ($overrideChargeModels == null ? 43 : ((Object)$overrideChargeModels).hashCode());
        Plan $plan = this.getPlan();
        result = result * 59 + ($plan == null ? 43 : ((Object)$plan).hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : $updateTime.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        List<Links> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Agreement(id=" + this.getId() + ", state=" + this.getState() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", startDate=" + this.getStartDate() + ", agreementDetails=" + this.getAgreementDetails() + ", payer=" + this.getPayer() + ", shippingAddress=" + this.getShippingAddress() + ", overrideMerchantPreferences=" + this.getOverrideMerchantPreferences() + ", overrideChargeModels=" + this.getOverrideChargeModels() + ", plan=" + this.getPlan() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ", token=" + this.getToken() + ", links=" + this.getLinks() + ")";
    }
}

